

<?php $__env->startSection('title', 'Contact Us - ' . ($global_settings['college_name'] ?? 'College Name')); ?>

<?php $__env->startSection('content'); ?>

<!-- Page Header -->
<div class="bg-primary text-white py-5">
    <div class="container py-4">
        <h1 class="font-serif display-4 fw-bold">Contact Us</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>" class="text-white-50 text-decoration-none">Home</a></li>
                <li class="breadcrumb-item active text-white" aria-current="page">Contact</li>
            </ol>
        </nav>
    </div>
</div>

<div class="container py-5">
    <div class="row g-5">
        <!-- Contact Info Cards -->
        <div class="col-lg-4">
            <div class="row g-4">
                <div class="col-12">
                     <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-4 d-flex gap-3">
                            <div class="bg-primary bg-opacity-10 rounded p-3 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-map-marker-alt text-primary fa-lg"></i>
                            </div>
                            <div>
                                <h5 class="fw-bold mb-1">Our Location</h5>
                                <p class="text-muted small mb-0"><?php echo e($global_settings['contact_full_address'] ?? 'Dhaka, Bangladesh'); ?></p>
                            </div>
                        </div>
                     </div>
                </div>
                <div class="col-12">
                     <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-4 d-flex gap-3">
                            <div class="bg-success bg-opacity-10 rounded p-3 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-phone text-success fa-lg"></i>
                            </div>
                            <div>
                                <h5 class="fw-bold mb-1">Phone Number</h5>
                                <p class="text-muted small mb-0"><?php echo e($global_settings['contact_office_phone'] ?? '+880 1234 567890'); ?></p>
                            </div>
                        </div>
                     </div>
                </div>
                <div class="col-12">
                     <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-4 d-flex gap-3">
                            <div class="bg-info bg-opacity-10 rounded p-3 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-envelope text-info fa-lg"></i>
                            </div>
                            <div>
                                <h5 class="fw-bold mb-1">Email Address</h5>
                                <p class="text-muted small mb-0"><?php echo e($global_settings['contact_general_email'] ?? 'info@college.edu.bd'); ?></p>
                            </div>
                        </div>
                     </div>
                </div>
            </div>
            
            <!-- Social Links -->
            <div class="mt-5">
                <h5 class="fw-bold font-serif mb-3">Follow Us</h5>
                <div class="d-flex gap-2">
                    <?php if(!empty($global_settings['social_facebook'])): ?>
                        <a href="<?php echo e($global_settings['social_facebook']); ?>" class="btn btn-outline-primary rounded-circle" style="width: 40px; height: 40px;"><i class="fab fa-facebook-f"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($global_settings['social_youtube'])): ?>
                        <a href="<?php echo e($global_settings['social_youtube']); ?>" class="btn btn-outline-danger rounded-circle" style="width: 40px; height: 40px;"><i class="fab fa-youtube"></i></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Map & Form -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
                <div class="card-body p-0">
                    <!-- Google Map -->
                    <div style="height: 300px; background: #eee;">
                         <?php if(!empty($global_settings['contact_map_url'])): ?>
                            <iframe src="<?php echo e($global_settings['contact_map_url']); ?>" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                        <?php else: ?>
                            <div class="w-100 h-100 d-flex align-items-center justify-content-center text-muted">
                                <i class="fas fa-map-marked-alt fa-3x"></i>
                                <span class="ms-3">Map URL not configured</span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/frontend/contact.blade.php ENDPATH**/ ?>