

<?php $__env->startSection('title', 'Academic Transcript - ' . $student->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="transcript-page-container py-5 bg-light">
        <!-- Navigation -->
        <div class="container mb-4 d-print-none">
            <div class="row">
                <div class="col-12">
                    <a href="<?php echo e(route('result')); ?>" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i> Back to Search
                    </a>
                </div>
            </div>
        </div>

        <!-- A4 Transcript Sheet -->
        <div class="a4-transcript mx-auto bg-white shadow-sm position-relative d-flex flex-column" id="printableArea">
            <!-- Background Watermark/Pattern -->
            <div class="watermark position-absolute top-50 start-50 translate-middle text-center opacity-10"
                style="z-index: 0; pointer-events: none;">
                <?php
                    $watermarkLogo = $global_settings['site_logo'] ?? 'frontend/assets/img/logo.png';
                    if (preg_match('/^(http|data:)/', $watermarkLogo)) {
                        $watermarkUrl = $watermarkLogo;
                    } elseif (file_exists(public_path('storage/' . $watermarkLogo))) {
                        $watermarkUrl = asset('storage/' . $watermarkLogo);
                    } else {
                        $watermarkUrl = asset($watermarkLogo);
                    }
                ?>
                <img src="<?php echo e($watermarkUrl); ?>" alt="Watermark"
                    style="width: 400px; opacity: 0.05; filter: grayscale(100%);">
            </div>

            <div class="content position-relative flex-grow-1" style="z-index: 1;">
                <!-- Header Section -->
                <div class="transcript-header text-center mb-4">
                    <div class="row align-items-center">

                        <div class="col-12">
                            <h2 class="college-name fw-bold text-uppercase mb-1"
                                style="font-family: 'Times New Roman', serif; font-size: 24pt; color: #000;">
                                <?php echo e($global_settings['college_name'] ?? 'SHEIKH ABDUL WOHAB MODEL COLLEGE'); ?>

                            </h2>
                            <p class="college-address mb-2 fw-bold"
                                style="font-family: 'Times New Roman', serif; font-size: 12pt;">
                                Singari, Abhaynagar, Jeshore
                            </p>

                            <h3 class="exam-title mt-3 fw-bold text-uppercase"
                                style="font-family: 'Times New Roman', serif; font-size: 16pt; border-bottom: 2px solid #000; display: inline-block; padding-bottom: 2px;">
                                <?php echo e($exam->name); ?>

                            </h3>
                        </div>
                    </div>

                    <div class="text-center mt-3">
                        <span class="transcript-label text-success fst-italic fw-bold"
                            style="font-family: 'Monotype Corsiva', 'Apple Chancery', cursive; font-size: 20pt; letter-spacing: 1px; color: #2E7D32;">
                            ACADEMIC TRANSCRIPT
                        </span>
                    </div>
                </div>

                <!-- Student Info Section (Grid Layout) -->
                <div class="student-info mb-4 ps-2 pe-4">
                    <div class="row mb-1">
                        <div class="col-3 fw-bold font-serif">Name of Student</div>
                        <div class="col-1 text-center">:</div>
                        <div class="col-8 fw-bold font-serif text-uppercase"><?php echo e($student->name); ?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-3 fw-bold font-serif">Father's Name</div>
                        <div class="col-1 text-center">:</div>
                        <div class="col-8 fw-bold font-serif text-uppercase"><?php echo e($student->father_name ?? '-'); ?></div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-3 fw-bold font-serif">Mother's Name</div>
                        <div class="col-1 text-center">:</div>
                        <div class="col-8 fw-bold font-serif text-uppercase"><?php echo e($student->mother_name ?? '-'); ?></div>
                    </div>

                    <!-- Line Separator or Spacing -->
                    <div class="row mt-3">
                        <div class="col-6">
                            <div class="row mb-1">
                                <div class="col-5 fw-bold font-serif">Roll No.</div>
                                <div class="col-1 text-center">:</div>
                                <div class="col-6 fw-bold font-serif"><?php echo e($student->class_roll); ?></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="row mb-1">
                                <div class="col-5 fw-bold font-serif">Registration No.</div>
                                <div class="col-1 text-center">:</div>
                                <div class="col-6 fw-bold font-serif"><?php echo e($student->ssc_reg_no ?? $student->student_id); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="row mb-1">
                                <div class="col-5 fw-bold font-serif">Group</div>
                                <div class="col-1 text-center">:</div>
                                <div class="col-6 fw-bold font-serif"><?php echo e($student->group ?? 'General'); ?></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="row mb-1">
                                <div class="col-5 fw-bold font-serif">Class</div>
                                <div class="col-1 text-center">:</div>
                                <div class="col-6 fw-bold font-serif">
                                    <?php echo e($student->class == '11' ? 'XI' : ($student->class == '12' ? 'XII' : $student->class)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="row mb-1">
                                <div class="col-5 fw-bold font-serif">Date of Birth</div>
                                <div class="col-1 text-center">:</div>
                                <div class="col-6 fw-bold font-serif">
                                    <?php echo e($student->date_of_birth ? date('d/m/Y', strtotime($student->date_of_birth)) : '-'); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Marks Table -->
                <div class="marks-table-container mt-2">
                    <table class="table table-bordered w-100 transcript-table text-black"
                        style="border-color: #000; font-family: 'Times New Roman', serif;">
                        <thead class="text-center align-middle" style="border-bottom: 2px solid #000;">
                            <tr>
                                <th rowspan="2" style="width: 10%; border: 1px solid #000;">Subject Code</th>
                                <th rowspan="2" style="width: 35%; border: 1px solid #000;">Subject Name</th>
                                <th colspan="4" style="width: 45%; border: 1px solid #000;">Marks</th>
                                <th rowspan="2" style="width: 10%; border: 1px solid #000;">Grade</th>
                            </tr>
                            <tr style="font-size: 0.9em;">
                                <th style="border: 1px solid #000;">Theory</th>
                                <th style="border: 1px solid #000;">Practical</th>
                                <th style="border: 1px solid #000;">MCQ</th>
                                <th style="border: 1px solid #000;">Total</th>
                            </tr>
                        </thead>
                        <tbody class="align-middle text-center font-serif">
                            <?php
                                // Identify optional subjects
                                $optionalSubjectIds = $student->subjects->filter(function ($s) {
                                    return (bool) ($s->pivot->is_optional ?? false);
                                })->pluck('id')->toArray();

                                $groupedMarks = $marks->groupBy(function ($mark) {
                                    // Normalize subject name to group papers
                                    $name = $mark->subject->name ?? '';
                                    return trim(str_ireplace(['1st Paper', '2nd Paper', 'First Paper', 'Second Paper', '1st', '2nd', ' I', ' II', '-I', '-II'], '', $name));
                                })->sortBy(function ($group) use ($optionalSubjectIds) {
                                    // Sort optional subjects to the end
                                    foreach ($group as $mark) {
                                        if (in_array($mark->subject_id, $optionalSubjectIds)) {
                                            return 1;
                                        }
                                    }
                                    return 0;
                                });

                                $gradeRules = json_decode($global_settings['grade_rules'] ?? '[]', true);
                                usort($gradeRules, function ($a, $b) {
                                    return $b['min_percentage'] <=> $a['min_percentage'];
                                });
                            ?>

                            <?php $__currentLoopData = $groupedMarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subjectName => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $mark = $group->first(); // Single ResultMark row for the subject
                                    $subject = $mark->subject;
                                    $sRule = $exam->subjectRules->where('subject_id', $subject->id)->first();
                                    $paperMode = $sRule->paper_mode ?? 'merged';
                                    $hasMultiplePapers = $subject->has_multiple_papers; // Uses newly added accessor/column

                                    $isSeparateView = ($paperMode === 'separate' && $hasMultiplePapers);

                                    // Common Calculations (Total & Grade) - applies to the Subject as a whole
                                    $totalObtained = $mark->total_marks;
                                    $grade = $mark->subject_grade;

                                    if ($group->count() > 1) {
                                        // Fallback for legacy data if multiple rows exist
                                        $totalObtained = $group->sum('total_marks');
                                        // Recalculate grade? Or assume first row? Let's stick to simple single row assumption for now as per controller logic.
                                    }

                                    // Check if this is an optional subject
                                    $isOptionalSubject = false;
                                    foreach ($group as $m) {
                                        if (in_array($m->subject_id, $optionalSubjectIds)) {
                                            $isOptionalSubject = true;
                                            break;
                                        }
                                    }

                                    $rowStyle = $isOptionalSubject ? 'background-color: #f5f5f5;' : '';
                                ?>

                                <?php if($isSeparateView): ?>
                                    
                                    <?php
                                        $papers = $subject->papers->sortBy('paper_code');
                                    ?>
                                    <?php $__currentLoopData = $papers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paperIndex => $paper): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            // Lighter border for inner rows of separate mode
                                                            $topBorder = $paperIndex > 0 ? 'border-top: 1px dotted #ccc;' : 'border-top: 1px solid #000;';
                                                        ?>
                                           <tr
                                                            style="<?php echo e($topBorder); ?> border-left: 1px solid #000; border-right: 1px solid #000; border-bottom: 1px solid #000; <?php echo e($rowStyle); ?>">
                                                            
                                                            <td style="border-right: 1px solid #000;"><?php echo e($paper->paper_code ?? '-'); ?></td>

                                                            
                                                            <td class="text-start ps-3" style="border-right: 1px solid #000;">
                                                                <span class="fw-bold"><?php echo e($subject->name); ?></span> <span
                                                                    class="text-muted small"><?php echo e($paper->paper_type == 'first' ? '1st Paper' : '2nd Paper'); ?></span>
                                                                <?php if($isOptionalSubject && $paperIndex == 0): ?>
                                                                    <span class="small text-muted fw-normal fst-italic ms-1">(4th Subject)</span>
                                                                <?php endif; ?>
                                                            </td>

                                                            
                                                            <?php
                                                                $pStats = [];
                                                                if ($paper->paper_type == 'first') {
                                                                    $pStats['cq'] = $mark->first_paper_cq;
                                                                    $pStats['prac'] = $mark->first_paper_practical;
                                                                    $pStats['mcq'] = $mark->first_paper_mcq;
                                                                } else {
                                                                    $pStats['cq'] = $mark->second_paper_cq;
                                                                    $pStats['prac'] = $mark->second_paper_practical;
                                                                    $pStats['mcq'] = $mark->second_paper_mcq;
                                                                }
                                                            ?>

                                                            <td style="border: 1px solid #000;">
                                                                <?php echo e($pStats['cq'] > 0 ? sprintf('%03d', $pStats['cq']) : '-'); ?>

                                                            </td>
                                                            <td style="border: 1px solid #000;">
                                                                <?php echo e($pStats['prac'] > 0 ? sprintf('%03d', $pStats['prac']) : ''); ?>

                                                            </td>
                                                            <td style="border: 1px solid #000;">
                                                                <?php echo e($pStats['mcq'] > 0 ? sprintf('%03d', $pStats['mcq']) : ''); ?>

                                                            </td>

                                                            
                                                            <?php if($loop->first): ?>
                                                                <td rowspan="<?php echo e($papers->count()); ?>" class="fw-bold align-middle"
                                                                    style="border: 1px solid #000;">
                                                                    <?php echo e(number_format($totalObtained, 2)); ?>

                                                                </td>
                                                                <td rowspan="<?php echo e($papers->count()); ?>" class="fw-bold align-middle"
                                                                    style="border: 1px solid #000;">
                                                                    <?php echo e($grade); ?>

                                                                </td>
                                                            <?php endif; ?>
                                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    
                                    <tr style="border: 1px solid #000; <?php echo e($rowStyle); ?>">
                                        
                                        <td style="border: 1px solid #000;"><?php echo e($subject->code ?? '-'); ?></td>

                                        
                                        <td class="text-start ps-3 fw-bold" style="border: 1px solid #000;">
                                            <?php echo e($subject->name); ?>

                                            <?php if($isOptionalSubject): ?>
                                                <span class="small text-muted fw-normal fst-italic ms-1">(4th Subject)</span>
                                            <?php endif; ?>
                                        </td>

                                        
                                        <td style="border: 1px solid #000;">
                                            <?php $cq = ($mark->first_paper_cq + $mark->second_paper_cq); ?>
                                            <?php echo e($cq > 0 ? sprintf('%03d', $cq) : '-'); ?>

                                        </td>
                                        <td style="border: 1px solid #000;">
                                            <?php $prac = ($mark->first_paper_practical + $mark->second_paper_practical); ?>
                                            <?php echo e($prac > 0 ? sprintf('%03d', $prac) : ''); ?>

                                        </td>
                                        <td style="border: 1px solid #000;">
                                            <?php $mcq = ($mark->first_paper_mcq + $mark->second_paper_mcq); ?>
                                            <?php echo e($mcq > 0 ? sprintf('%03d', $mcq) : ''); ?>

                                        </td>

                                        
                                        <td class="fw-bold align-middle" style="border: 1px solid #000;">
                                            <?php echo e(number_format($totalObtained, 2)); ?>

                                        </td>
                                        <td class="fw-bold align-middle" style="border: 1px solid #000;">
                                            <?php echo e($grade); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <!-- Final Result Row -->
                            <tr class="fw-bold" style="border-top: 2px solid #000;">
                                <td colspan="6" class="text-end pe-3" style="border: 1px solid #000;">Grade Point Average
                                    (GPA)</td>
                                <td class="text-center" style="border: 1px solid #000;">
                                    <?php echo e(number_format($final_result->gpa, 2)); ?>

                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="text-start ps-2 mt-2 font-serif mb-4">
                    <strong>Result:</strong>
                    <span class="<?php echo e($final_result->grade == 'F' ? 'text-danger' : 'text-success'); ?>">
                        <?php echo e($final_result->grade == 'F' ? 'FAILED' : 'PASSED'); ?>

                    </span>
                </div>
            </div>

            <!-- Footer Section (Pushed to bottom) -->
            <div class="footer-section mt-auto position-relative" style="z-index: 1;">
                <!-- Signatures -->
                <div class="signature-block text-end pe-5 mb-3">
                    <div class="d-inline-block text-center" style="width: 250px;">
                        <?php if(!empty($global_settings['controller_examination_signature'])): ?>
                            <img src="<?php echo e(asset('storage/' . $global_settings['controller_examination_signature'])); ?>" alt="Sig"
                                height="40" class="mb-1">
                        <?php else: ?>
                            <img src="<?php echo e(asset('frontend/assets/img/signature.png')); ?>" class="d-none" alt="Sig" height="40">
                            <div style="height: 40px;" class="d-block"></div> <!-- Spacer if no image -->
                        <?php endif; ?>
                        <div class="signature-line w-100 border-top border-dark border-2 pt-1">
                            <p class="fw-bold font-serif mb-0">Controller of Examinations</p>
                        </div>
                    </div>
                </div>

                <div class="footer text-start pt-2 border-top border-dark">
                    <small class="font-serif">Date of Publication of Result: <?php echo e(date('d F, Y')); ?></small>
                </div>
            </div>
        </div>

        <!-- Print & Download Buttons -->
        <div class="d-print-none text-center mt-4">
            <button onclick="window.print()" class="btn btn-dark rounded-pill px-4 shadow-sm">
                <i class="fas fa-print me-2"></i> Print Result
            </button>
        </div>
    </div>

    <!-- html2pdf CDN Removed -->

    <script>
            // No specific JS needed for server-side download
    </script>

    <style>
        /* A4 Formatting */
        .a4-transcript {
            width: 210mm;
            min-height: 297mm;
            padding: 40px 50px;
            box-sizing: border-box;
            border: 1px solid #ddd;
        }

        .font-serif {
            font-family: "Times New Roman", Times, serif;
        }

        .transcript-table th,
        .transcript-table td {
            border-color: #000 !important;
            padding: 4px 8px;
            /* Compact padding */
        }

        /* Print Styles */
        @media print {

            /* Reset page settings */
            @page {
                size: A4;
                margin: 0;
            }

            /* Hide everything by default using visibility to avoid layout shifts initially, 
                   but display:none for known containers is safer for multiple pages */
            body * {
                visibility: hidden;
            }

            /* Hide layout elements completely to remove their space */
            nav,
            footer,
            .navbar,
            .footer,
            .d-print-none {
                display: none !important;
            }

            /* Target the specific printable area */
            #printableArea,
            #printableArea * {
                visibility: visible;
            }

            /* Position the watermarks/content correctly */
            #printableArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: auto;
                /* Allow height to fit content, don't force it */
                margin: 0;
                padding: 20px 40px !important;
                /* Reduced padding to fit single page */
                border: none !important;
                box-shadow: none !important;
                background: white !important;
                min-height: auto !important;
                /* Override min-height to prevent forcing extra length */
            }

            /* Ensure watermark is faint but visible */
            .watermark {
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                opacity: 0.05 !important;
                visibility: visible !important;
                z-index: -1;
            }

            /* Ensure the wrapper doesn't interfere */
            .transcript-page-container {
                background: white !important;
                padding: 0 !important;
                margin: 0 !important;
            }

            body,
            html {
                background: white !important;
                height: auto !important;
                /* Allow auto height */
                overflow: visible !important;
                -webkit-print-color-adjust: exact;
            }

            /* Compact Header for Print */
            .transcript-header {
                margin-bottom: 1rem !important;
            }

            .college-name {
                font-size: 20pt !important;
                /* Slightly smaller */
                margin-bottom: 0 !important;
            }

            .college-address {
                margin-bottom: 0.5rem !important;
            }

            .exam-title {
                margin-top: 0.5rem !important;
                font-size: 14pt !important;
            }
        }

        /* Mobile Responsiveness */
        @media screen and (max-width: 850px) {
            .a4-transcript {
                width: 95% !important;
                min-height: auto;
                padding: 20px 15px;
                margin: 20px auto;
            }

            .college-name {
                font-size: 18pt !important;
            }

            .exam-title {
                font-size: 14pt !important;
            }

            .transcript-label {
                font-size: 16pt !important;
            }

            .marks-table-container {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
                margin-bottom: 15px;
            }

            .transcript-table {
                min-width: 600px;
                /* Ensure table doesn't squish too much */
            }

            .transcript-page-container {
                padding-top: 20px !important;
                padding-bottom: 20px !important;
            }

            .footer-section {
                margin-top: 30px !important;
            }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/frontend/result-sheet.blade.php ENDPATH**/ ?>