

<?php $__env->startSection('title', 'Terms of Use - ' . ($global_settings['college_name'] ?? 'College Name')); ?>

<?php $__env->startSection('content'); ?>
<div class="legal-page-wrapper py-5 bg-light position-relative overflow-hidden">
    <!-- Decor bg shapes -->
    <div class="position-absolute top-0 start-0 translate-middle rounded-circle bg-primary opacity-5 p-5 blur-3xl" style="width: 400px; height: 400px; filter: blur(80px);"></div>
    <div class="position-absolute bottom-0 end-0 translate-middle rounded-circle bg-info opacity-5 p-5 blur-3xl" style="width: 300px; height: 300px; filter: blur(60px);"></div>

    <div class="container py-4 position-relative z-1">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb" class="mb-5 animate-up">
             <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>" class="text-muted text-decoration-none small text-uppercase fw-bold ls-1"><i class="fas fa-home me-1"></i> Home</a></li>
                <li class="breadcrumb-item active text-primary small text-uppercase fw-bold ls-1" aria-current="page">Terms of Use</li>
            </ol>
        </nav>

        <div class="row justify-content-center animate-up" style="animation-delay: 0.1s;">
            <div class="col-lg-10">
                <div class="card border-0 shadow-xl rounded-4 overflow-hidden position-relative">
                    <div class="position-absolute top-0 start-0 w-100 h-1 bg-gradient-primary"></div>
                    
                    <div class="card-body p-4 p-md-5 bg-white">
                        <div class="text-center mb-5">
                            <div class="d-inline-flex align-items-center justify-content-center bg-primary bg-opacity-10 text-primary rounded-circle mb-3" style="width: 64px; height: 64px;">
                                <i class="fas fa-file-contract fa-2x"></i>
                            </div>
                            <h1 class="fw-bold font-serif display-5 mb-2">Terms of Use</h1>
                            <p class="text-muted small">Last Updated: <?php echo e(date('d F, Y')); ?></p>
                        </div>

                        <div class="content opacity-75">
                            <h4 class="fw-bold text-dark mb-3">1. Acceptance of Terms</h4>
                            <p class="mb-4">By accessing and using the <?php echo e($global_settings['college_name'] ?? 'College Name'); ?> website, you accept and agree to be bound by the terms and provision of this agreement.</p>
                            
                            <h4 class="fw-bold text-dark mb-3">2. Use License</h4>
                            <p class="mb-4">Permission is granted to temporarily download one copy of the materials (information or software) on our website for personal, non-commercial transitory viewing only. This is the grant of a license, not a transfer of title.</p>

                            <h4 class="fw-bold text-dark mb-3">3. Academic Integrity</h4>
                            <p class="mb-4">Students and users are expected to maintain high standards of academic integrity. Any falsification of results, records, or documents accessed through this portal is strictly prohibited and legal action may be taken.</p>
                            
                            <h4 class="fw-bold text-dark mb-3">4. Limitations</h4>
                            <p class="mb-4">In no event shall <?php echo e($global_settings['college_name'] ?? 'College Name'); ?> or its suppliers be liable for any damages (including, without limitation, damages for loss of data or profit, or due to business interruption) arising out of the use or inability to use the materials on our website.</p>

                            <h4 class="fw-bold text-dark mb-3">5. Revisions</h4>
                            <p class="mb-0">The materials appearing on our website could include technical, typographical, or photographic errors. We do not warrant that any of the materials on its website are accurate, complete, or current. We may make changes to the materials contained on our website at any time without notice.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .ls-1 { letter-spacing: 1px; }
    .shadow-xl { box-shadow: 0 20px 40px rgba(0,0,0,0.08) !important; }
    .bg-gradient-primary { background: linear-gradient(to right, var(--bs-primary), var(--bs-info)); }
    
    .animate-up {
        animation: fadeInUp 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
        opacity: 0;
        transform: translateY(30px);
    }
    
    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .blur-3xl { filter: blur(3rem); }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/frontend/terms-of-use.blade.php ENDPATH**/ ?>