

<?php $__env->startSection('title', 'View Results'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('result-management.index')); ?>">Results</a></li>
    <li class="breadcrumb-item active" aria-current="page">View Results</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-12">
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <div>
                    <h5 class="mb-0 fw-bold"><?php echo e($exam->name); ?></h5>
                    <p class="text-muted small mb-0">
                        Batch: <?php echo e($exam->batch->name); ?> | 
                        Year: <?php echo e($exam->start_date->format('Y')); ?> | 
                        Template: <?php echo e($exam->examTemplate->name); ?>

                    </p>
                </div>
                <div class="d-flex gap-2">
                    <?php if($exam->is_published): ?>
                        <form action="<?php echo e(route('result-management.unpublish', $exam)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-danger text-white">
                                <i class="bi bi-eye-slash-fill me-1"></i> Unpublish Results
                            </button>
                        </form>
                    <?php else: ?>
                        <form action="<?php echo e(route('result-management.publish', $exam)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-eye-fill me-1"></i> Publish Results
                            </button>
                        </form>
                    <?php endif; ?>
                    <a href="<?php echo e(route('result-management.index')); ?>" class="btn btn-light border">
                        <i class="bi bi-arrow-left me-1"></i> Back
                    </a>
                </div>
            </div>

            <div class="card-body">
                <?php if($results->isEmpty()): ?>
                    <div class="text-center py-5">
                        <div class="mb-3 text-muted opacity-25">
                             <i class="bi bi-clipboard-data display-4"></i>
                        </div>
                        <h5 class="text-muted">No results found</h5>
                        <p class="text-muted small mb-4">No results have been processed for this exam yet.</p>
                        <a href="<?php echo e(route('result-management.students', $exam)); ?>" class="btn btn-success">
                            <i class="bi bi-plus-lg me-1"></i> Enter Marks
                        </a>
                    </div>
                <?php else: ?>
                    
                    <div class="row g-3 mb-4">
                        <div class="col-md-6 col-lg-3">
                            <div class="card border-0 bg-primary-subtle text-primary h-100">
                                <div class="card-body d-flex align-items-center">
                                    <div class="rounded-circle bg-white p-3 me-3 text-primary shadow-sm" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                        <i class="bi bi-people-fill fs-4"></i>
                                    </div>
                                    <div>
                                        <div class="small fw-bold opacity-75">Total Students</div>
                                        <div class="h3 mb-0 fw-bold"><?php echo e($results->count()); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3">
                            <div class="card border-0 bg-success-subtle text-success h-100">
                                <div class="card-body d-flex align-items-center">
                                    <div class="rounded-circle bg-white p-3 me-3 text-success shadow-sm" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                        <i class="bi bi-check-circle-fill fs-4"></i>
                                    </div>
                                    <div>
                                        <div class="small fw-bold opacity-75">Passed</div>
                                        <div class="h3 mb-0 fw-bold"><?php echo e($results->where('result_status', 'passed')->count()); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3">
                            <div class="card border-0 bg-danger-subtle text-danger h-100">
                                <div class="card-body d-flex align-items-center">
                                    <div class="rounded-circle bg-white p-3 me-3 text-danger shadow-sm" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                        <i class="bi bi-x-circle-fill fs-4"></i>
                                    </div>
                                    <div>
                                        <div class="small fw-bold opacity-75">Failed</div>
                                        <div class="h3 mb-0 fw-bold"><?php echo e($results->where('result_status', 'failed')->count()); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3">
                            <div class="card border-0 bg-info-subtle text-info-emphasis h-100">
                                <div class="card-body d-flex align-items-center">
                                    <div class="rounded-circle bg-white p-3 me-3 text-info shadow-sm" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                        <i class="bi bi-pie-chart-fill fs-4"></i>
                                    </div>
                                    <div>
                                        <div class="small fw-bold opacity-75">Pass Rate</div>
                                        <div class="h3 mb-0 fw-bold">
                                            <?php echo e($results->count() > 0 ? round(($results->where('result_status', 'passed')->count() / $results->count()) * 100, 2) : 0); ?>%
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th class="ps-3 border-bottom-0">Rank</th>
                                    <th class="border-bottom-0">Roll</th>
                                    <th class="border-bottom-0">Student Name</th>
                                    <th class="text-center border-bottom-0">Total Marks</th>
                                    <th class="text-center border-bottom-0">GPA</th>
                                    <th class="text-center border-bottom-0">Grade</th>
                                    <th class="text-center border-bottom-0">Status</th>
                                    <th class="text-end pe-3 border-bottom-0">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="ps-3">
                                        <?php if($result->position === 1): ?>
                                            <span class="badge rounded-pill bg-warning text-dark border border-warning shadow-sm px-3 py-2">
                                                <i class="bi bi-trophy-fill me-1"></i> 1st
                                            </span>
                                        <?php elseif($result->position === 2): ?>
                                            <span class="badge rounded-pill bg-secondary text-white border border-secondary shadow-sm px-3 py-2">
                                                <i class="bi bi-award-fill me-1"></i> 2nd
                                            </span>
                                        <?php elseif($result->position === 3): ?>
                                            <span class="badge rounded-pill bg-white text-warning-emphasis border border-warning px-3 py-2">
                                                <i class="bi bi-award me-1"></i> 3rd
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-light text-secondary border px-3 py-2">
                                                #<?php echo e($result->position ?? '-'); ?>

                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="fw-bold text-dark"><?php echo e($result->student->class_roll); ?></span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-circle bg-primary-subtle text-primary rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                                                <span class="fw-bold small"><?php echo e(substr($result->student->name, 0, 1)); ?></span>
                                            </div>
                                            <div>
                                                <div class="fw-bold text-dark"><?php echo e($result->student->name); ?></div>
                                                <div class="small text-muted"><?php echo e($result->student->student_id); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <span class="fw-bold"><?php echo e($result->total_marks); ?></span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-info-subtle text-info-emphasis border border-info-subtle">
                                            <?php echo e(number_format($result->gpa, 2)); ?>

                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <?php
                                            $gradeColor = match($result->grade) {
                                                'A+' => 'success',
                                                'A' => 'success',
                                                'A-' => 'primary',
                                                'B' => 'info',
                                                'C' => 'warning',
                                                'D' => 'warning',
                                                default => 'danger'
                                            };
                                        ?>
                                        <span class="badge bg-<?php echo e($gradeColor); ?>"><?php echo e($result->grade); ?></span>
                                    </td>
                                    <td class="text-center">
                                        <?php if($result->result_status === 'passed'): ?>
                                            <span class="badge bg-success-subtle text-success border border-success-subtle">
                                                <i class="bi bi-check-circle me-1"></i> Passed
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-danger-subtle text-danger border border-danger-subtle">
                                                <i class="bi bi-x-circle me-1"></i> Failed
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end pe-3">
                                        <a href="<?php echo e(route('result-management.enter', ['exam' => $exam, 'student' => $result->student])); ?>" 
                                           class="btn btn-sm btn-outline-primary shadow-sm" 
                                           data-bs-toggle="tooltip" title="View/Edit Details">
                                            <i class="bi bi-eye"></i> Details
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4 px-3">
                        <?php echo e($results->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/result-management/view-results.blade.php ENDPATH**/ ?>