

<?php $__env->startSection('title', 'Enter Marks: ' . $student->name); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('result-management.index')); ?>">Results</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('result-management.students', $exam)); ?>"><?php echo e($exam->name); ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e($student->name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-lg-10">
        <form action="<?php echo e(route('result-management.save', ['exam' => $exam, 'student' => $student])); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <!-- Header Card -->
            <div class="card shadow-sm border-0 mb-4 bg-primary text-white">
                <div class="card-body py-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-1 fw-bold"><?php echo e($student->name); ?></h4>
                            <p class="mb-0 opacity-75">
                                Roll: <?php echo e($student->class_roll); ?> | 
                                Batch: <?php echo e($exam->batch->name); ?> | 
                                Year: <?php echo e($exam->start_date->format('Y')); ?>

                            </p>
                        </div>
                        <a href="<?php echo e(route('result-management.students', $exam)); ?>" class="btn btn-light bg-white bg-opacity-10 text-white border-0 hover-bg-opacity-20">
                            <i class="bi bi-arrow-left me-1"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <?php $__currentLoopData = $subjectsWithConfig; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subjectData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $subject = $subjectData['subject'];
                        $paperMode = $subjectData['paper_mode'];
                        $config = $subjectData['config'];
                        $existingMark = $subjectData['existing_marks'];
                        
                        // Robust logic for flags and max marks (Merged)
                        $hasMcq = $config['has_mcq'] ?? $subject->has_mcq ?? false;
                        $mcqMax = $config['mcq_marks'] ?? 0;

                        $hasCq = $config['has_cq'] ?? $subject->has_cq ?? false;
                        $cqMax = $config['cq_marks'] ?? 0;

                        $hasPractical = $config['has_practical'] ?? $subject->has_practical ?? false;
                        $practicalMax = $config['practical_marks'] ?? 0;

                        // Robust logic for Separate
                        // P1
                        $p1HasMcq = $config['paper1_has_mcq'] ?? $subject->has_first_paper; // Fallback loose
                        $p1McqMax = $config['paper1_mcq_marks'] ?? 0;
                        $p1HasCq = $config['paper1_has_cq'] ?? $subject->has_first_paper;
                        $p1CqMax = $config['paper1_cq_marks'] ?? 0;
                        $p1HasPrac = $config['paper1_has_practical'] ?? false;
                        $p1PracMax = $config['paper1_practical_marks'] ?? 0;

                        // P2
                        $p2HasMcq = $config['paper2_has_mcq'] ?? $subject->has_second_paper;
                        $p2McqMax = $config['paper2_mcq_marks'] ?? 0;
                        $p2HasCq = $config['paper2_has_cq'] ?? $subject->has_second_paper;
                        $p2CqMax = $config['paper2_cq_marks'] ?? 0;
                        $p2HasPrac = $config['paper2_has_practical'] ?? false;
                        $p2PracMax = $config['paper2_practical_marks'] ?? 0;
                    ?>

                    <div class="col-12">
                        <div class="card shadow-sm border-0">
                            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0 fw-bold text-primary"><?php echo e($subject->name); ?> <span class="text-muted fw-normal ms-2">(<?php echo e($subject->code); ?>)</span></h6>
                                </div>
                                <div class="small">
                                    <span class="badge <?php echo e($paperMode === 'merged' ? 'bg-info-subtle text-info-emphasis' : 'bg-purple-subtle text-purple-emphasis'); ?>"><?php echo e(ucfirst($paperMode)); ?> Mode</span>
                                    <span class="badge bg-light text-dark border ms-2">Total: <?php echo e($subjectData['total_marks']); ?></span>
                                    <span class="badge bg-light text-dark border ms-1">Pass: <?php echo e($subjectData['pass_marks']); ?></span>
                                </div>
                            </div>
                            
                            <div class="card-body">
                                <input type="hidden" name="marks[<?php echo e($loop->index); ?>][subject_id]" value="<?php echo e($subject->id); ?>">

                                <?php if($paperMode === 'merged'): ?>
                                    <div class="row g-3">
                                        <?php if($hasMcq): ?>
                                            <div class="col-md-4">
                                                <label class="form-label small fw-bold text-muted">MCQ (Max: <?php echo e($mcqMax); ?>)</label>
                                                <input type="number" 
                                                       name="marks[<?php echo e($loop->index); ?>][first_paper_mcq]" 
                                                       value="<?php echo e(old('marks.'.$loop->index.'.first_paper_mcq', $existingMark->first_paper_mcq ?? '')); ?>"
                                                       min="0" max="<?php echo e($mcqMax); ?>" step="0.01"
                                                       class="form-control" placeholder="-">
                                            </div>
                                        <?php endif; ?>
                                        <?php if($hasCq): ?>
                                            <div class="col-md-4">
                                                <label class="form-label small fw-bold text-muted">CQ (Max: <?php echo e($cqMax); ?>)</label>
                                                <input type="number" 
                                                       name="marks[<?php echo e($loop->index); ?>][first_paper_cq]" 
                                                       value="<?php echo e(old('marks.'.$loop->index.'.first_paper_cq', $existingMark->first_paper_cq ?? '')); ?>"
                                                       min="0" max="<?php echo e($cqMax); ?>" step="0.01"
                                                       class="form-control" placeholder="-">
                                            </div>
                                        <?php endif; ?>
                                        <?php if($hasPractical): ?>
                                            <div class="col-md-4">
                                                <label class="form-label small fw-bold text-muted">Practical (Max: <?php echo e($practicalMax); ?>)</label>
                                                <input type="number" 
                                                       name="marks[<?php echo e($loop->index); ?>][first_paper_practical]" 
                                                       value="<?php echo e(old('marks.'.$loop->index.'.first_paper_practical', $existingMark->first_paper_practical ?? '')); ?>"
                                                       min="0" max="<?php echo e($practicalMax); ?>" step="0.01"
                                                       class="form-control" placeholder="-">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php else: ?>
                                    
                                    <div class="row g-3">
                                        
                                        <?php if($subject->has_first_paper): ?>
                                            <div class="col-md-6 border-end">
                                                <h6 class="text-primary fw-bold mb-3 small text-uppercase">First Paper</h6>
                                                <div class="row g-2">
                                                    <?php if($p1HasMcq): ?>
                                                        <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="MCQ"
                                                                       name="marks[<?php echo e($loop->index); ?>][first_paper_mcq]" 
                                                                       value="<?php echo e(old('marks.'.$loop->index.'.first_paper_mcq', $existingMark->first_paper_mcq ?? '')); ?>"
                                                                       min="0" max="<?php echo e($p1McqMax); ?>" step="0.01">
                                                                <label>MCQ (<?php echo e($p1McqMax); ?>)</label>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if($p1HasCq): ?>
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="CQ"
                                                                       name="marks[<?php echo e($loop->index); ?>][first_paper_cq]" 
                                                                       value="<?php echo e(old('marks.'.$loop->index.'.first_paper_cq', $existingMark->first_paper_cq ?? '')); ?>"
                                                                       min="0" max="<?php echo e($p1CqMax); ?>" step="0.01">
                                                                <label>CQ (<?php echo e($p1CqMax); ?>)</label>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if($p1HasPrac): ?>
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="Prac"
                                                                       name="marks[<?php echo e($loop->index); ?>][first_paper_practical]" 
                                                                       value="<?php echo e(old('marks.'.$loop->index.'.first_paper_practical', $existingMark->first_paper_practical ?? '')); ?>"
                                                                       min="0" max="<?php echo e($p1PracMax); ?>" step="0.01">
                                                                <label>Prac (<?php echo e($p1PracMax); ?>)</label>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        
                                        <?php if($subject->has_second_paper): ?>
                                            <div class="col-md-6 ps-md-4">
                                                <h6 class="text-success fw-bold mb-3 small text-uppercase">Second Paper</h6>
                                                <div class="row g-2">
                                                     <?php if($p2HasMcq): ?>
                                                        <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="MCQ"
                                                                       name="marks[<?php echo e($loop->index); ?>][second_paper_mcq]" 
                                                                       value="<?php echo e(old('marks.'.$loop->index.'.second_paper_mcq', $existingMark->second_paper_mcq ?? '')); ?>"
                                                                       min="0" max="<?php echo e($p2McqMax); ?>" step="0.01">
                                                                <label>MCQ (<?php echo e($p2McqMax); ?>)</label>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if($p2HasCq): ?>
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="CQ"
                                                                       name="marks[<?php echo e($loop->index); ?>][second_paper_cq]" 
                                                                       value="<?php echo e(old('marks.'.$loop->index.'.second_paper_cq', $existingMark->second_paper_cq ?? '')); ?>"
                                                                       min="0" max="<?php echo e($p2CqMax); ?>" step="0.01">
                                                                <label>CQ (<?php echo e($p2CqMax); ?>)</label>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if($p2HasPrac): ?>
                                                         <div class="col-4">
                                                            <div class="form-floating">
                                                                <input type="number" class="form-control" placeholder="Prac"
                                                                       name="marks[<?php echo e($loop->index); ?>][second_paper_practical]" 
                                                                       value="<?php echo e(old('marks.'.$loop->index.'.second_paper_practical', $existingMark->second_paper_practical ?? '')); ?>"
                                                                       min="0" max="<?php echo e($p2PracMax); ?>" step="0.01">
                                                                <label>Prac (<?php echo e($p2PracMax); ?>)</label>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Sticky Footer Action -->
            <div class="card fixed-bottom border-top shadow-lg" style="bottom: 0px; z-index: 100;">
                <div class="card-body py-3">
                    <div class="container d-flex justify-content-end gap-2">
                         <a href="<?php echo e(route('result-management.students', $exam)); ?>" class="btn btn-light border px-4">Cancel</a>
                        <button type="submit" class="btn btn-primary px-5 fw-bold shadow-sm">
                            <i class="bi bi-save me-2"></i> Save Marks
                        </button>
                    </div>
                </div>
            </div>
            <!-- Spacer for fixed footer -->
            <div style="height: 100px;"></div>

        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/result-management/enter-marks.blade.php ENDPATH**/ ?>