

<?php $__env->startSection('title', 'Edit Exam'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid p-0">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="mb-0 fw-bold text-primary"><i class="fas fa-edit me-2"></i>Edit Exam</h5>
                        <p class="text-muted small mb-0 mt-1">Update examination details</p>
                    </div>
                    <a href="<?php echo e(route('exams.index')); ?>" class="btn btn-outline-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i> Back to List
                    </a>
                </div>

                <div class="card-body p-4">
                    <form action="<?php echo e(route('exams.update', $exam)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="row g-4">
                            <!-- Basic Information -->
                            <div class="col-12">
                                <h6 class="fw-bold border-bottom pb-2 mb-3 text-secondary">Basic Information</h6>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label fw-bold small text-uppercase">Exam Name <span class="text-danger">*</span></label>
                                    <input type="text" name="name" id="name" value="<?php echo e(old('name', $exam->name)); ?>" class="form-control" placeholder="e.g. First Term Examination 2024" required>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold small text-uppercase">Exam Template</label>
                                    <input type="text" value="<?php echo e($exam->examTemplate->name ?? 'N/A'); ?>" class="form-control bg-light" disabled>
                                    <div class="form-text text-muted"><i class="fas fa-lock me-1"></i> Template rules cannot be changed</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="batch_id" class="form-label fw-bold small text-uppercase">Batch <span class="text-danger">*</span></label>
                                    <select name="batch_id" id="batch_id" class="form-select" required>
                                        <option value="">Select Batch</option>
                                        <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($batch->id); ?>" <?php echo e(old('batch_id', $exam->batch_id) == $batch->id ? 'selected' : ''); ?>>
                                                <?php echo e($batch->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['batch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="class" class="form-label fw-bold small text-uppercase">Class <span class="text-danger">*</span></label>
                                    <select name="class" id="class" class="form-select" required>
                                        <option value="11" <?php echo e(old('class', $exam->class) == '11' ? 'selected' : ''); ?>>Class XI</option>
                                        <option value="12" <?php echo e(old('class', $exam->class) == '12' ? 'selected' : ''); ?>>Class XII</option>
                                    </select>
                                    <?php $__errorArgs = ['class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Schedule & Status -->
                            <div class="col-12 mt-4">
                                <h6 class="fw-bold border-bottom pb-2 mb-3 text-secondary">Schedule & Status</h6>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="start_date" class="form-label fw-bold small text-uppercase">Start Date</label>
                                    <input type="date" name="start_date" id="start_date" 
                                           value="<?php echo e(old('start_date', $exam->start_date ? \Carbon\Carbon::parse($exam->start_date)->format('Y-m-d') : '')); ?>" 
                                           class="form-control">
                                    <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="end_date" class="form-label fw-bold small text-uppercase">End Date</label>
                                    <input type="date" name="end_date" id="end_date" 
                                           value="<?php echo e(old('end_date', $exam->end_date ? \Carbon\Carbon::parse($exam->end_date)->format('Y-m-d') : '')); ?>" 
                                           class="form-control">
                                    <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="status" class="form-label fw-bold small text-uppercase">Status <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-select" required>
                                        <option value="upcoming" <?php echo e(old('status', $exam->status) == 'upcoming' ? 'selected' : ''); ?>>Upcoming</option>
                                        <option value="open_for_entry" <?php echo e(old('status', $exam->status) == 'open_for_entry' ? 'selected' : ''); ?>>Open for Entry</option>
                                        <option value="published" <?php echo e(old('status', $exam->status) == 'published' ? 'selected' : ''); ?>>Published</option>
                                        <option value="archived" <?php echo e(old('status', $exam->status) == 'archived' ? 'selected' : ''); ?>>Archived</option>
                                    </select>
                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="text-end mt-4 pt-3 border-top">
                            <a href="<?php echo e(route('exams.index')); ?>" class="btn btn-light me-2">Cancel</a>
                            <button type="submit" class="btn btn-primary px-4 fw-bold shadow-sm">
                                <i class="fas fa-save me-2"></i> Update Exam
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/exams/edit.blade.php ENDPATH**/ ?>