

<?php $__env->startSection('title', 'Contact Us - ' . ($global_settings['college_name'] ?? 'College Name')); ?>

<?php $__env->startSection('content'); ?>

<!-- Wrapper with same bg and decor as Result Page -->
<div class="contact-page-wrapper py-5 bg-light position-relative overflow-hidden">
    <!-- Decor bg shapes -->
    <div class="position-absolute top-0 start-0 translate-middle rounded-circle bg-primary opacity-5 p-5 blur-3xl" style="width: 400px; height: 400px; filter: blur(80px);"></div>
    <div class="position-absolute bottom-0 end-0 translate-middle rounded-circle bg-info opacity-5 p-5 blur-3xl" style="width: 300px; height: 300px; filter: blur(60px);"></div>

    <div class="container py-4 position-relative z-1">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb" class="mb-5 animate-up">
             <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>" class="text-muted text-decoration-none small text-uppercase fw-bold ls-1"><i class="fas fa-home me-1"></i> Home</a></li>
                <li class="breadcrumb-item active text-primary small text-uppercase fw-bold ls-1" aria-current="page">Contact</li>
            </ol>
        </nav>

        <div class="row g-5 align-items-center">
            
            <!-- Left Side: Hero Text & Contact Info -->
            <div class="col-lg-6 animate-up">
                <div class="pe-lg-5">
                    <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3 py-2 mb-3 fw-semibold">
                        <i class="fas fa-comments me-1"></i> We're Here to Help
                    </span>
                    <h1 class="font-serif display-4 fw-bold text-dark mb-4">
                        Get in <br>
                        <span class="text-primary position-relative">Touch With Us
                            <svg class="position-absolute start-0 bottom-0 w-100 text-warning opacity-50" height="12" viewBox="0 0 100 12" preserveAspectRatio="none" style="z-index: -1;">
                                <path d="M0,10 Q50,0 100,10" stroke="currentColor" stroke-width="8" fill="none" />
                            </svg>
                        </span>
                    </h1>
                    <p class="lead text-muted mb-5 opacity-75">
                        Have questions or need assistance? Reach out to our administration for official inquiries and support.
                    </p>
                    
                    <!-- Contact Details styled as Feature List -->
                    <div class="d-flex flex-column gap-4">
                        
                        <!-- Address -->
                        <div class="d-flex align-items-start gap-3">
                            <div class="icon-square bg-white shadow-sm text-primary rounded-circle d-flex align-items-center justify-content-center flex-shrink-0" style="width: 55px; height: 55px;">
                                <i class="fas fa-map-marker-alt fa-lg"></i>
                            </div>
                            <div>
                                <h6 class="fw-bold mb-1 text-dark">Our Campus</h6>
                                <p class="text-muted mb-0" style="line-height: 1.5;">
                                    <?php echo nl2br(e($global_settings['contact_full_address'] ?? 'Dhaka, Bangladesh')); ?>

                                </p>
                            </div>
                        </div>

                        <!-- Phone -->
                        <div class="d-flex align-items-center gap-3">
                            <div class="icon-square bg-white shadow-sm text-success rounded-circle d-flex align-items-center justify-content-center flex-shrink-0" style="width: 55px; height: 55px;">
                                <i class="fas fa-phone-alt fa-lg"></i>
                            </div>
                            <div>
                                <h6 class="fw-bold mb-1 text-dark">Call Us</h6>
                                <a href="tel:<?php echo e($global_settings['contact_office_phone'] ?? ''); ?>" class="text-decoration-none text-muted mb-0 d-block hover-text-primary">
                                    <?php echo e($global_settings['contact_office_phone'] ?? '+880 1234 567890'); ?>

                                </a>
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="d-flex align-items-center gap-3">
                            <div class="icon-square bg-white shadow-sm text-info rounded-circle d-flex align-items-center justify-content-center flex-shrink-0" style="width: 55px; height: 55px;">
                                <i class="fas fa-envelope fa-lg"></i>
                            </div>
                            <div>
                                <h6 class="fw-bold mb-1 text-dark">Email Us</h6>
                                <a href="mailto:<?php echo e($global_settings['contact_general_email'] ?? ''); ?>" class="text-decoration-none text-muted mb-0 d-block hover-text-primary">
                                    <?php echo e($global_settings['contact_general_email'] ?? 'info@college.edu.bd'); ?>

                                </a>
                            </div>
                        </div>

                    </div>
                    
                    <!-- Social Links -->
                    <div class="mt-5 pt-3">
                        <p class="small fw-bold text-uppercase text-muted ls-1 mb-3">Connect Socially</p>
                        <div class="d-flex gap-3">
                            <?php if(!empty($global_settings['social_facebook'])): ?>
                                <a href="<?php echo e($global_settings['social_facebook']); ?>" target="_blank" class="btn btn-white shadow-sm rounded-circle d-flex align-items-center justify-content-center text-primary hover-lift" style="width: 45px; height: 45px;"><i class="fab fa-facebook-f"></i></a>
                            <?php endif; ?>
                            <?php if(!empty($global_settings['social_youtube'])): ?>
                                <a href="<?php echo e($global_settings['social_youtube']); ?>" target="_blank" class="btn btn-white shadow-sm rounded-circle d-flex align-items-center justify-content-center text-danger hover-lift" style="width: 45px; height: 45px;"><i class="fab fa-youtube"></i></a>
                            <?php endif; ?>
                             <?php if(!empty($global_settings['social_twitter'])): ?>
                                <a href="<?php echo e($global_settings['social_twitter']); ?>" target="_blank" class="btn btn-white shadow-sm rounded-circle d-flex align-items-center justify-content-center text-info hover-lift" style="width: 45px; height: 45px;"><i class="fab fa-twitter"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            </div>

            <!-- Right Side: Map Card (Instead of Search Form) -->
            <div class="col-lg-5 offset-lg-1 animate-up" style="animation-delay: 0.2s;">
                <div class="card border-0 shadow-xl rounded-4 overflow-hidden position-relative" style="min-height: 500px;">
                    <div class="position-absolute top-0 start-0 w-100 h-1 bg-gradient-primary"></div>
                    
                    <!-- Google Map Iframe -->
                    <div class="card-body p-0 h-100 bg-white">
                        <?php if(!empty($global_settings['contact_map_url'])): ?>
                            <iframe 
                                src="<?php echo e($global_settings['contact_map_url']); ?>" 
                                width="100%" 
                                height="100%" 
                                style="border:0; min-height: 500px;" 
                                allowfullscreen="" 
                                loading="lazy" 
                                referrerpolicy="no-referrer-when-downgrade">
                            </iframe>
                        <?php else: ?>
                            <div class="w-100 h-100 d-flex flex-column align-items-center justify-content-center bg-light text-muted p-5" style="min-height: 500px;">
                                <i class="fas fa-map-marked-alt fa-5x mb-3 opacity-25"></i>
                                <h5 class="fw-bold opacity-50">Map Location</h5>
                                <p class="small opacity-50">Map URL has not been configured.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<style>
    .ls-1 { letter-spacing: 1px; }
    .shadow-xl { box-shadow: 0 20px 40px rgba(0,0,0,0.08) !important; }
    .bg-gradient-primary { background: linear-gradient(to right, var(--bs-primary), var(--bs-info)); }
    .hover-lift { transition: transform 0.3s ease, box-shadow 0.3s ease; }
    .hover-lift:hover { transform: translateY(-3px); box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important; }
    .hover-text-primary:hover { color: var(--bs-primary) !important; }
    
    .font-serif {
        font-family: 'Times New Roman', Times, serif; 
    }
    
    .animate-up {
        animation: fadeInUp 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
        opacity: 0;
        transform: translateY(30px);
    }
    
    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .blur-3xl { filter: blur(3rem); }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/frontend/contact.blade.php ENDPATH**/ ?>