<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', $global_settings['college_name'] ?? 'College Name'); ?></title>

    <?php
        $favicon = $global_settings['site_favicon'] ?? 'frontend/assets/img/favicon.png';
        if (preg_match('/^(http|data:)/', $favicon)) {
            $favUrl = $favicon;
        } elseif (file_exists(public_path('storage/' . $favicon))) {
            $favUrl = asset('storage/' . $favicon);
        } else {
            $favUrl = asset($favicon);
        }
    ?>
    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e($favUrl); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e($favUrl); ?>" type="image/x-icon">

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap&subset=bengali"
        rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Playfair+Display:wght@400;600;700&display=swap"
        rel="stylesheet">
    <style>
        :root {
            --primary: #0d6efd;
            --primary-dark: #0a58ca;
            --secondary: #6c757d;
            --footer-bg: #1a1d20;
            --glass-bg: rgba(255, 255, 255, 0.65);
            /* More transparent for better glass effect */
            --glass-border: rgba(255, 255, 255, 0.4);
            --glass-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            /* Premium glass shadow */
        }

        html,
        body {
            overflow-x: hidden;
            width: 100%;
        }

        body {
            font-family: 'Hind Siliguri', 'Outfit', sans-serif;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            background-color: #f3f4f6;
            padding-top: 90px;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        .font-serif {
            font-family: 'Playfair Display', serif;
        }

        /* Premium Navbar Styles */
        .navbar-premium {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            /* Stronger blur */
            -webkit-backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--glass-border);
            box-shadow: var(--glass-shadow);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            padding: 1rem 0;
        }

        .navbar-premium.scrolled {
            padding: 0.7rem 0;
            background: rgba(255, 255, 255, 0.85);
            /* Slightly more solid on scroll for readability */
            backdrop-filter: blur(25px);
            -webkit-backdrop-filter: blur(25px);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
        }

        .navbar-brand img {
            height: 50px;
            width: 50px;
            object-fit: contain;
            transition: transform 0.3s ease;
        }

        .navbar-brand:hover img {
            transform: scale(1.05) rotate(5deg);
        }

        .nav-link {
            font-weight: 500;
            color: #4b5563;
            padding: 0.5rem 1rem !important;
            transition: all 0.3s ease;
            position: relative;
        }

        /* Hover Effect: Animated Underline */
        .nav-link::after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            bottom: 0px;
            left: 50%;
            background-color: var(--primary);
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }

        .nav-link:hover,
        .nav-link.active {
            color: var(--primary);
        }

        .nav-link:hover::after,
        .nav-link.active::after {
            width: 80%;
        }

        .btn-premium {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            border: none;
            color: white;
            transition: all 0.3s ease;
            position: relative;
            z-index: 1;
            overflow: hidden;
        }

        .btn-premium:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(13, 110, 253, 0.4);
            color: white;
        }

        /* Mobile Menu Toggle Animation */
        .navbar-toggler {
            border: none;
            padding: 0;
            width: 34px;
            height: 24px;
            position: relative;
            transition: .5s ease-in-out;
            cursor: pointer;
            z-index: 1001;
            /* Ensure above overlay */
        }

        .navbar-toggler:focus {
            box-shadow: none;
            outline: none;
        }

        .navbar-toggler span {
            display: block;
            position: absolute;
            height: 3px;
            width: 100%;
            background: #2d3748;
            border-radius: 4px;
            opacity: 1;
            left: 0;
            transform-origin: center;
            transition: .3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        }

        .navbar-toggler span:nth-child(1) {
            top: 0px;
        }

        .navbar-toggler span:nth-child(2) {
            top: 10px;
        }

        .navbar-toggler span:nth-child(3) {
            top: 20px;
        }

        /* Hover Effect */
        .navbar-toggler:hover span {
            background: var(--primary);
        }

        /* Active (Open) State Animation */
        .navbar-toggler[aria-expanded="true"] span:nth-child(1) {
            top: 10px;
            transform: rotate(45deg);
        }

        .navbar-toggler[aria-expanded="true"] span:nth-child(2) {
            opacity: 0;
            transform: scale(0.5);
            /* Shrink effect instead of flying */
        }

        .navbar-toggler[aria-expanded="true"] span:nth-child(3) {
            top: 10px;
            transform: rotate(-45deg);
        }

        /* Mobile Menu Overlay - Premium Circle Clip Reveal */
        @media (max-width: 991.98px) {
            .navbar-collapse {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(255, 255, 255, 0.9);
                backdrop-filter: blur(20px);
                -webkit-backdrop-filter: blur(20px);
                z-index: 1000;
                padding: 1.5rem;
                /* Standard padding for the card-like feel */
                height: 100vh !important;

                /* Animation State: Clip Path Circle */
                opacity: 1;
                visibility: visible;
                /* Always visible for clip-path to work, we toggle the clip size */
                clip-path: circle(0% at calc(100% - 40px) 40px);
                /* Adjust 40px based on toggler position */
                transition: clip-path 0.4s cubic-bezier(0.65, 0, 0.35, 1);
                /* Sped up from 0.6s */

                display: block !important;
                pointer-events: none;
                /* Prevent clicks when closed (clipped to 0) */
            }

            .navbar-collapse.show {
                clip-path: circle(140% at calc(100% - 40px) 40px);
                pointer-events: auto;
            }

            /* Staggered Item Animation - Slide In from Right */
            .nav-item {
                opacity: 0;
                transform: translateX(30px);
                /* Reduced slide distance for speed */
                transition: all 0.3s ease-out;
                /* Sped up from 0.4s */
            }

            .navbar-collapse.show .nav-item {
                opacity: 1;
                transform: translateX(0);
            }

            /* Stagger delays for "Waterfall" effect - tighter timing */
            .navbar-collapse.show .nav-item:nth-child(1) {
                transition-delay: 0.05s;
            }

            .navbar-collapse.show .nav-item:nth-child(2) {
                transition-delay: 0.1s;
            }

            .navbar-collapse.show .nav-item:nth-child(3) {
                transition-delay: 0.15s;
            }

            .navbar-collapse.show .nav-item:nth-child(4) {
                transition-delay: 0.2s;
            }

            .navbar-collapse.show .nav-item:nth-child(5) {
                transition-delay: 0.25s;
            }

            .navbar-collapse.show .nav-item:nth-child(6) {
                transition-delay: 0.3s;
            }

            .navbar-collapse.show .nav-item:nth-child(7) {
                transition-delay: 0.35s;
            }

            /* Mobile Links Styling */
            .nav-link {
                font-size: 1.5rem;
                font-weight: 700;
                font-family: 'Playfair Display', serif;
                padding: 15px 0 !important;
                border-bottom: 1px solid rgba(0, 0, 0, 0.05);
                color: #2d3748;
            }

            .nav-link::after {
                display: none;
            }

            .nav-link.active,
            .nav-link:hover {
                color: var(--primary);
                padding-left: 15px !important;
                background: transparent;
                border: none;
            }

            /* Login Button Mobile Adjustment */
            .nav-item .btn-premium {
                width: 100%;
                margin-top: 1rem;
                padding: 1rem;
                font-size: 1.2rem;
            }
        }

        /* Disable automatic top adjustment JS for this new full-screen style */

        /* Mobile Branding Adjustments */
        @media (max-width: 576px) {
            .navbar-brand img {
                height: 40px;
                width: 40px;
            }

            .navbar-brand span {
                font-size: 1.1rem !important;
                /* Smaller font for mobile */
                white-space: normal;
                /* Allow wrapping */
                max-width: 200px;
                /* Prevent overflow */
                line-height: 1.2;
            }

            .navbar-premium {
                padding: 0.5rem 0;
            }
        }

        /* Footer */
        footer {
            margin-top: auto;
            background: var(--footer-bg);
            color: #adb5bd;
            padding-top: 4rem;
            padding-bottom: 2rem;
        }

        footer a {
            /* ... existing footer styles ... */
            color: #adb5bd;
            text-decoration: none;
            transition: color 0.2s;
        }

        footer a:hover {
            color: #fff;
            padding-left: 5px;
        }

        .social-icon {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            margin-right: 0.5rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
        }

        .social-icon:hover {
            background: var(--primary);
            transform: translateY(-3px);
            color: #fff;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>

    <!-- Premium Sticky Navbar -->
    <nav class="navbar navbar-expand-lg fixed-top navbar-premium" id="mainNavbar">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center gap-2 gap-md-3" href="<?php echo e(route('home')); ?>">
                <div class="d-flex align-items-center justify-content-center">
                        <?php
                            $logo = $global_settings['site_logo'] ?? 'frontend/assets/img/logo.png';
                            if (preg_match('/^(http|data:)/', $logo)) {
                                $logoUrl = $logo;
                            } elseif (file_exists(public_path('storage/' . $logo))) {
                                $logoUrl = asset('storage/' . $logo);
                            } else {
                                $logoUrl = asset($logo);
                            }
                        ?>
                    <img src="<?php echo e($logoUrl); ?>" alt="Logo" class="rounded-circle shadow-sm" style="object-fit: cover;">
                </div>
                <div class="d-flex flex-column justify-content-center">
                    <span
                        class="fw-bold font-serif text-dark fs-4 d-none d-sm-block"><?php echo e($global_settings['college_name'] ?? 'College Name'); ?></span>
                    <!-- Mobile View -->
                    <span
                        class="fw-bold font-serif text-dark d-block d-sm-none"><?php echo e($global_settings['college_name'] ?? 'College Name'); ?></span>
                </div>
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navContent"
                aria-controls="navContent" aria-expanded="false" aria-label="Toggle navigation">
                <span></span>
                <span></span>
                <span></span>
            </button>

            <div class="collapse navbar-collapse" id="navContent">
                <!-- Mobile Menu Header (Visible only on mobile) -->
                <div class="d-lg-none d-flex justify-content-between align-items-center mb-4 pb-3 border-bottom">
                    <a class="d-flex align-items-center gap-2 text-decoration-none" href="<?php echo e(route('home')); ?>">
                        <?php
                            $logo = $global_settings['site_logo'] ?? 'frontend/assets/img/logo.png';
                            if (preg_match('/^(http|data:)/', $logo)) {
                                $logoUrl = $logo;
                            } elseif (file_exists(public_path('storage/' . $logo))) {
                                $logoUrl = asset('storage/' . $logo);
                            } else {
                                $logoUrl = asset($logo);
                            }
                        ?>
                        <img src="<?php echo e($logoUrl); ?>" alt="Logo" class="rounded-circle shadow-sm"
                            style="width: 40px; height: 40px; object-fit: cover;">
                        <span
                            class="fw-bold font-serif text-dark"><?php echo e($global_settings['college_name'] ?? 'College Name'); ?></span>
                    </a>
                    <!-- Redundant close button removed (Hamburglar acts as X) -->
                </div>

                <ul class="navbar-nav ms-auto mb-3 mb-lg-0 align-items-lg-center">
                    <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>"
                            href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('about') ? 'active' : ''); ?>"
                            href="<?php echo e(route('about')); ?>">About</a></li>
                    <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('notice*') ? 'active' : ''); ?>"
                            href="<?php echo e(route('notice')); ?>">Notices</a></li>
                    <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('teachers') ? 'active' : ''); ?>"
                            href="<?php echo e(route('teachers')); ?>">Faculty</a></li>
                    <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('result') ? 'active' : ''); ?>"
                            href="<?php echo e(route('result')); ?>">Results</a></li>
                    <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>"
                            href="<?php echo e(route('contact')); ?>">Contact</a></li>

                    <li class="nav-item ms-lg-3 mt-3 mt-lg-0">
                        <a href="<?php echo e(url('/admin')); ?>" class="btn btn-premium rounded-pill px-4 py-2 shadow-sm fw-bold">
                            <i class="fas fa-sign-in-alt me-1"></i> Login
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Script to handle dynamic navbar height and scroll effect -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const navbar = document.getElementById('mainNavbar');

            // Handle Scroll Animation
            window.addEventListener('scroll', function () {
                if (window.scrollY > 50) {
                    navbar.classList.add('scrolled');
                } else {
                    navbar.classList.remove('scrolled');
                }
            });
        });
    </script>

    <!-- Main Content -->
    <main class="flex-grow-1">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer style="background: #111; color: #b0b0b0; padding-top: 5rem; padding-bottom: 2rem;">
        <div class="container">
            <div class="row g-5">
                <!-- Brand & About -->
                <div class="col-lg-5 col-md-6">
                    <div class="d-flex align-items-center gap-3 mb-4">
                        <?php
                            $footerLogo = $global_settings['site_logo'] ?? 'frontend/assets/img/logo.png';
                            if (preg_match('/^(http|data:)/', $footerLogo)) {
                                $footerLogoUrl = $footerLogo;
                            } elseif (file_exists(public_path('storage/' . $footerLogo))) {
                                $footerLogoUrl = asset('storage/' . $footerLogo);
                            } else {
                                $footerLogoUrl = asset($footerLogo);
                            }
                        ?>
                        <img src="<?php echo e($footerLogoUrl); ?>" alt="Logo" class="rounded-4 shadow-sm"
                            style="height: 50px; width: 50px; object-fit: cover;">
                        <span
                            class="fw-bold text-white fs-5 font-serif"><?php echo e($global_settings['college_name'] ?? 'College Name'); ?></span>
                    </div>
                    <p class="small opacity-75 mb-4" style="line-height: 1.6;">
                        <?php echo e($global_settings['footer_about'] ?? 'We are committed to providing quality education, fostering academic excellence, and building the character of our students for a better future.'); ?>

                    </p>
                    <div class="d-flex gap-2">
                        <?php $__currentLoopData = ['social_facebook' => 'facebook-f', 'social_youtube' => 'youtube', 'social_twitter' => 'twitter', 'social_instagram' => 'instagram']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $icon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!empty($global_settings[$key])): ?>
                                <a href="<?php echo e($global_settings[$key]); ?>"
                                    class="social-icon text-center rounded-circle d-flex align-items-center justify-content-center"
                                    style="width: 40px; height: 40px; background: rgba(255,255,255,0.05); color: #fff; text-decoration: none; transition: all 0.3s;"
                                    target="_blank">
                                    <i class="fab fa-<?php echo e($icon); ?>"></i>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="col-lg-3 col-md-6 ps-lg-5">
                    <h5 class="text-white mb-4 font-serif">Quick Links</h5>
                    <ul class="list-unstyled d-flex flex-column gap-2 small">
                        <li><a href="<?php echo e(route('about')); ?>"
                                class="text-decoration-none text-white-50 hover-white transition">About Us</a></li>
                        <li><a href="<?php echo e(route('notice')); ?>"
                                class="text-decoration-none text-white-50 hover-white transition">Notices</a></li>
                        <li><a href="<?php echo e(route('result')); ?>"
                                class="text-decoration-none text-white-50 hover-white transition">Results</a></li>
                        <li><a href="<?php echo e(route('teachers')); ?>"
                                class="text-decoration-none text-white-50 hover-white transition">Faculty</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>"
                                class="text-decoration-none text-white-50 hover-white transition">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Contact Info -->
                <div class="col-lg-4 col-md-6">
                    <h5 class="text-white mb-4 font-serif">Contact Us</h5>
                    <ul class="list-unstyled small d-flex flex-column gap-3">
                        <li class="d-flex gap-3">
                            <div class="mt-1"><i class="fas fa-map-marker-alt text-primary"></i></div>
                            <span
                                class="opacity-75"><?php echo nl2br(e($global_settings['contact_full_address'] ?? 'Dhaka, Bangladesh')); ?></span>
                        </li>
                        <li class="d-flex gap-3">
                            <div class="mt-1"><i class="fas fa-phone text-primary"></i></div>
                            <span
                                class="opacity-75"><?php echo e($global_settings['contact_office_phone'] ?? '+880 1234 567890'); ?></span>
                        </li>
                        <li class="d-flex gap-3">
                            <div class="mt-1"><i class="fas fa-envelope text-primary"></i></div>
                            <span class="opacity-75"><?php echo e($global_settings['contact_general_email'] ??
                                'info@college.edu.bd'); ?></span>
                        </li>
                    </ul>
                </div>
            </div>

            <hr class="my-5" style="border-color: rgba(255,255,255,0.1);">

            <div
                class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3 small opacity-50">
                <p class="mb-2 mb-md-0">&copy; <?php echo e(date('Y')); ?> <?php echo e($global_settings['college_name'] ?? 'College Name'); ?>.
                    All rights reserved.</p>
                <div class="d-flex gap-3">
                    <a href="<?php echo e(route('privacy-policy')); ?>"
                        class="text-decoration-none text-white-50 hover-white transition">Privacy Policy</a>
                    <a href="<?php echo e(route('terms-of-use')); ?>"
                        class="text-decoration-none text-white-50 hover-white transition">Terms of Use</a>
                </div>
            </div>
        </div>

        <style>
            .hover-white:hover {
                color: #fff !important;
                padding-left: 5px;
            }

            .transition {
                transition: all 0.3s ease;
            }

            .social-icon:hover {
                transform: translateY(-5px);
                background: var(--primary) !important;
            }
        </style>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>