

<?php $__env->startSection('title', 'Result Management'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Results</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('exams.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i> Create Exam
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if($exams->isEmpty()): ?>
    <div class="card p-5 text-center border-0 shadow-sm">
        <div class="mb-3">
             <i class="bi bi-journal-text fs-1 text-muted opacity-50"></i>
        </div>
        <h5 class="text-muted">No exams available for results</h5>
        <p class="text-muted small">Create an exam first to start entering marks.</p>
        <div class="mt-3">
            <a href="<?php echo e(route('exams.create')); ?>" class="btn btn-primary">Create First Exam</a>
        </div>
    </div>
<?php else: ?>
    <div class="row g-4">
        <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <div>
                                <h5 class="card-title fw-bold text-dark mb-1"><?php echo e($exam->name); ?></h5>
                                <span class="badge bg-light text-dark border"><?php echo e($exam->batch->name ?? 'N/A'); ?></span>
                            </div>
                            <?php if($exam->status === 'upcoming'): ?>
                                <span class="badge bg-warning-subtle text-warning-emphasis">Upcoming</span>
                            <?php elseif($exam->status === 'ongoing'): ?>
                                <span class="badge bg-success-subtle text-success-emphasis">Ongoing</span>
                            <?php else: ?>
                                <span class="badge bg-secondary-subtle text-secondary-emphasis">Completed</span>
                            <?php endif; ?>
                        </div>

                        <div class="small text-muted mb-4">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-calendar3 me-2 text-primary"></i>
                                <?php echo e($exam->start_date ? \Carbon\Carbon::parse($exam->start_date)->format('M d, Y') : 'N/A'); ?>

                            </div>
                            <div class="d-flex align-items-center">
                                <i class="bi bi-file-earmark-text me-2 text-primary"></i>
                                <?php echo e($exam->examTemplate->name ?? 'No Template'); ?>

                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <a href="<?php echo e(route('result-management.students', $exam)); ?>" class="btn btn-primary flex-fill">
                                <i class="bi bi-pencil-square me-1"></i> Enter Marks
                            </a>
                            <a href="<?php echo e(route('result-management.view-results', $exam)); ?>" class="btn btn-outline-success flex-fill">
                                <i class="bi bi-table me-1"></i> View Results
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="mt-4">
        <?php echo e($exams->links('pagination::bootstrap-5')); ?>

    </div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/result-management/index.blade.php ENDPATH**/ ?>