<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title><?php echo e($exam->name); ?> - Result Sheet</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 11px;
            color: #000;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            margin: 0 auto;
            padding: 10px;
            box-sizing: border-box;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h2 {
            margin: 0;
            font-size: 20px;
            text-transform: uppercase;
        }

        .header h3 {
            margin: 5px 0 0;
            font-size: 16px;
            font-weight: normal;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
        }

        th {
            background-color: #f0f0f0;
            font-weight: bold;
            font-size: 10px;
        }

        .text-left {
            text-align: left !important;
            padding-left: 8px;
        }
        
        .bg-light-gray {
            background-color: #f9f9f9;
        }

        .footer-section {
            margin-top: 40px;
            display: flex;
            justify-content: flex-end;
            padding-right: 20px;
        }

        .signature-box {
            text-align: center;
            width: 250px;
        }

        .signature-line {
            border-top: 1px solid #000;
            margin: 5px 0;
        }

        @media print {
            body {
                -webkit-print-color-adjust: exact;
                margin: 0;
                padding: 10mm; /* Add safe printing padding */
            }

            @page {
                size: A4 portrait;
                margin: 0; /* Remove browser default margins/headers/footers */
            }
            
            .container {
                width: 100%;
                max-width: 100%;
                padding: 0;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h2>Sheikh Abdul Wohab Model College</h2>
            <h3><?php echo e($exam->name); ?> - Result Sheet</h3>
            <p style="margin: 5px 0;">Year: <?php echo e(date('Y', strtotime($exam->start_date))); ?> | Batch:
                <?php echo e($exam->batch->name); ?></p>
        </div>

        <table>
            <thead>
                <tr>
                    <th style="width: 50px">Rank</th>
                    <th style="width: 80px">Roll</th>
                    <th style="width: auto">Student Name</th>
                    <th style="width: 60px">Total</th>
                    <th style="width: 50px">GPA</th>
                    <th style="width: 50px">Grade</th>
                    <th style="width: 70px">Result</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $student = $result->student;
                    ?>
                    <tr>
                        <td><?php echo e($result->position); ?></td>
                        <td><?php echo e($student->class_roll); ?></td>
                        <td class="text-left"><?php echo e($student->name); ?></td>
                        <td><?php echo e(number_format($result->total_marks, 0)); ?></td>
                        <td><?php echo e(number_format($result->gpa, 2)); ?></td>
                        <td><?php echo e($result->grade); ?></td>
                        <td>
                            <span style="color: <?php echo e($result->result_status == 'passed' ? 'green' : 'red'); ?>; font-weight: bold;">
                                <?php echo e($result->result_status == 'passed' ? 'PASS' : 'FAIL'); ?>

                            </span>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="footer-section">
            <div class="signature-box">
                <?php if($signature): ?>
                    <img src="<?php echo e(asset('storage/' . $signature)); ?>" height="50" alt="Signature">
                <?php else: ?>
                    <div style="height: 50px;"></div>
                <?php endif; ?>
                <div class="signature-line"></div>
                <strong>Controller of Examinations</strong>
            </div>
        </div>
    </div>
    <script>
        window.onload = function () {
            // window.print();
        }
    </script>
</body>

</html><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/exports/result-sheet.blade.php ENDPATH**/ ?>