<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Result Card - <?php echo e($student->class_roll); ?></title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 14px;
            color: #000;
        }

        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
            text-transform: uppercase;
        }

        .header h3 {
            margin: 5px 0 0;
            font-size: 18px;
            font-weight: normal;
        }

        .student-info {
            margin-bottom: 20px;
            width: 100%;
        }

        .info-row {
            display: flex;
            margin-bottom: 5px;
        }

        .info-label {
            width: 120px;
            font-weight: bold;
        }

        .info-sep {
            width: 20px;
            text-align: center;
        }

        .info-val {
            flex: 1;
            font-weight: bold;
        }

        /* Grid for Info */
        .info-table {
            width: 100%;
            border: none;
            margin-bottom: 20px;
        }

        .info-table td {
            padding: 4px 0;
            border: none;
            text-align: left;
        }

        .label {
            font-weight: bold;
            width: 15%;
        }

        .sep {
            width: 2%;
            text-align: center;
            font-weight: bold;
        }

        .val {
            width: 33%;
            font-weight: bold;
        }

        .font-bold {
            font-weight: bold;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        /* Highlight for 4th/Optional Subject */
        .optional-subject {
            background-color: #f0f0f0 !important;
        }

        .optional-subject td {
            font-style: italic;
            color: #555;
        }

        .footer-section {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
        }

        .signature-area {
            margin-top: 50px;
            text-align: center;
        }

        table.marks-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            border: 2px solid #000;
        }

        .marks-table th,
        .marks-table td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center;
            font-family: 'Times New Roman', serif;
        }

        .marks-table th {
            font-weight: bold;
            background-color: white;
        }

        .text-left {
            text-align: left !important;
        }

        .font-bold {
            font-weight: bold;
        }

        .footer-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
        }

        .signature-box {
            text-align: center;
            width: 250px;
            float: right;
        }

        .signature-line {
            border-top: 1px solid #000;
            margin: 5px 0;
        }

        @media print {
            body {
                -webkit-print-color-adjust: exact;
                margin: 0;
                padding: 20px;
            }

            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        
        <div class="header">
            <h2>Sheikh Abdul Wohab Model College</h2>
            <h3><?php echo e($exam->name); ?> Result - <?php echo e(date('Y', strtotime($exam->start_date))); ?></h3>
        </div>

        
        <table class="info-table">
            <tr>
                <td class="label">Father's Name</td>
                <td class="sep">:</td>
                <td class="val" colspan="4"><?php echo e($student->father_name); ?></td>
            </tr>
            <tr>
                <td class="label">Mother's Name</td>
                <td class="sep">:</td>
                <td class="val" colspan="4"><?php echo e($student->mother_name); ?></td>
            </tr>
            <tr>
                <td class="label">Roll No.</td>
                <td class="sep">:</td>
                <td class="val"><?php echo e($student->class_roll); ?></td>
                <td class="label">Registration No.</td>
                <td class="sep">:</td>
                <td class="val"><?php echo e($student->ssc_reg_no); ?></td>
            </tr>
            <tr>
                <td class="label">Group</td>
                <td class="sep">:</td>
                <td class="val"><?php echo e($student->group ?? 'N/A'); ?></td>
                <td class="label">Class</td>
                <td class="sep">:</td>
                <td class="val"><?php echo e($student->class); ?></td>
            </tr>
            <tr>
                <td class="label">Date of Birth</td>
                <td class="sep">:</td>
                <td class="val"><?php echo e(date('d/m/Y', strtotime($student->date_of_birth))); ?></td>
                <td class="label">Session</td>
                <td class="sep">:</td>
                <td class="val"><?php echo e($student->session); ?></td>
            </tr>
        </table>

        
        <table class="marks-table">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 8%;">Subject Code</th>
                    <th rowspan="2" style="width: 35%;">Subject Name</th>
                    <th colspan="3">Marks</th>
                    <th rowspan="2" style="width: 10%;">Total</th>
                    <th rowspan="2" style="width: 10%;">Grade</th>
                </tr>
                <tr>
                    <th style="width: 10%;">Theory</th>
                    <th style="width: 10%;">Practical</th>
                    <th style="width: 10%;">MCQ</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    // Create a lookup for optional subjects from the student's assigned subjects
                    // Using filter to ensure we correctly handle 1/0/true/false values from pivot
                    $optionalSubjectIds = $student->subjects->filter(function($subject) {
                        return (bool) ($subject->pivot->is_optional ?? false);
                    })->pluck('id')->toArray();

                    // Sort marks: Regular subjects first, then 4th/optional subject last
                    $sortedMarks = $marks->sortBy(function($mark) use ($optionalSubjectIds) {
                        return in_array($mark->subject_id, $optionalSubjectIds) ? 1 : 0;
                    });
                ?>

                <?php $__currentLoopData = $sortedMarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $subject = $mark->subject;
                        $hasSecondPaper = $subject->has_second_paper;
                        $rows = $hasSecondPaper ? 2 : 1;
                        $code = is_numeric($subject->code) ? $subject->code : $subject->code;

                        // Check if this is 4th/optional subject
                        $isFourthSubject = in_array($subject->id, $optionalSubjectIds);
                    ?>

                    
                    <tr class="<?php echo e($isFourthSubject ? 'optional-subject' : ''); ?>">
                        <td class="font-bold"><?php echo e($code); ?></td>
                        <td class="text-left font-bold">
                            <?php echo e($subject->name); ?><?php echo e($hasSecondPaper ? ' 1st Paper' : ''); ?>

                            <?php if($isFourthSubject): ?> <span style="font-size: 10px; color: #666; font-weight: normal;">(4th
                            Subject)</span> <?php endif; ?>
                        </td>
                        <td><?php echo e($mark->first_paper_cq ? sprintf('%03d', $mark->first_paper_cq) : ''); ?></td>
                        <td><?php echo e($mark->first_paper_practical ? sprintf('%03d', $mark->first_paper_practical) : ''); ?></td>
                        <td><?php echo e($mark->first_paper_mcq ? sprintf('%03d', $mark->first_paper_mcq) : ''); ?></td>

                        
                        <td rowspan="<?php echo e($rows); ?>" class="font-bold"><?php echo e(number_format($mark->total_marks, 2)); ?></td>
                        <td rowspan="<?php echo e($rows); ?>" class="font-bold"><?php echo e($mark->subject_grade); ?></td>
                    </tr>

                    
                    <?php if($hasSecondPaper): ?>
                        <tr class="<?php echo e($isFourthSubject ? 'optional-subject' : ''); ?>">
                            <td class="font-bold"><?php echo e(is_numeric($code) ? $code + 1 : $code); ?></td>
                            <td class="text-left font-bold"><?php echo e($subject->name); ?> 2nd Paper</td>
                            <td><?php echo e($mark->second_paper_cq ? sprintf('%03d', $mark->second_paper_cq) : ''); ?></td>
                            <td><?php echo e($mark->second_paper_practical ? sprintf('%03d', $mark->second_paper_practical) : ''); ?></td>
                            <td><?php echo e($mark->second_paper_mcq ? sprintf('%03d', $mark->second_paper_mcq) : ''); ?></td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <tr>
                    <td colspan="6" class="text-right font-bold" style="text-align: right; padding-right: 15px;">
                        Grade Point Average (GPA)
                    </td>
                    <td class="font-bold"><?php echo e(number_format($finalResult->gpa, 2)); ?></td>
                </tr>
            </tbody>
        </table>

        
        <div style="margin-top: 10px; font-size: 16px;">
            <strong>Result:</strong>
            <span style="color: <?php echo e($finalResult->grade == 'F' ? 'red' : 'green'); ?>">
                <?php echo e($finalResult->grade == 'F' ? 'FAILED' : 'PASSED'); ?>

            </span>
        </div>

        
        <div class="footer-section">
            <div style="font-size: 12px; color: #555;">
                Date of Publication of Result: <?php echo e(date('d F, Y')); ?>

                <br>
                <em>System Generated Report</em>
            </div>

            <div class="signature-box">
                <?php if($signature): ?>
                    <img src="<?php echo e(asset('storage/' . $signature)); ?>" height="50" alt="Signature">
                <?php else: ?>
                    <div style="height: 50px;"></div>
                <?php endif; ?>
                <div class="signature-line"></div>
                <strong>Controller of Examinations</strong>
            </div>
        </div>
    </div>
    <script>
        window.onload = function () {
            setTimeout(function () {
                window.print();
            }, 500);
        }
    </script>
</body>

</html><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/exports/result-pdf.blade.php ENDPATH**/ ?>