<?php $__env->startSection('title', 'Mark Entry: ' . $subject->name); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('result-management.index')); ?>">Results</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('result-management.students', $exam)); ?>"><?php echo e($exam->name); ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e($subject->name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-primary text-white py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1 fw-bold text-white"><?php echo e($subject->name); ?> (<?php echo e($subject->code); ?>)</h6>
                        <small class="text-white-50">Batch: <?php echo e($exam->batch->name); ?> | Year: <?php echo e($exam->start_date->format('Y')); ?></small>
                    </div>
                    <div class="text-end">
                        <div class="badge bg-white text-primary mb-1"><?php echo e(ucfirst($rule->paper_mode)); ?> Mode</div>
                        <div class="small text-white-50">Pass Marks: <?php echo e($rule->pass_marks); ?></div>
                    </div>
                </div>
            </div>

            <div class="card-body p-0">
                <form method="POST" action="<?php echo e(route('result-management.subject-save', ['exam' => $exam, 'subject' => $subject])); ?>">
                    <?php echo csrf_field(); ?>
                    
                    <div class="table-responsive">
                        <table class="table table-hover table-striped align-middle mb-0 table-bordered">
                            <?php
                                $cfg = is_array($rule->config) ? $rule->config : (json_decode($rule->config ?? '[]', true) ?: []);
                                
                                if (($rule->paper_mode ?? 'merged') === 'separate') {
                                    // Separate paper mode
                                    $markDist = $cfg['mark_distribution'] ?? [];
                                    $firstPaper = $markDist['first_paper'] ?? [];
                                    $secondPaper = $markDist['second_paper'] ?? [];
                                    
                                    // Get first paper marks - hide if 0 or not set
                                    $fmcqMax = ($firstPaper['mcq'] ?? 0) > 0 ? $firstPaper['mcq'] : null;
                                    $fcqMax = ($firstPaper['cq'] ?? 0) > 0 ? $firstPaper['cq'] : null;
                                    $fpracMax = ($firstPaper['practical'] ?? 0) > 0 ? $firstPaper['practical'] : null;
                                    
                                    // Get second paper marks - hide if 0 or not set
                                    $smcqMax = ($secondPaper['mcq'] ?? 0) > 0 ? $secondPaper['mcq'] : null;
                                    $scqMax = ($secondPaper['cq'] ?? 0) > 0 ? $secondPaper['cq'] : null;
                                    $spracMax = ($secondPaper['practical'] ?? 0) > 0 ? $secondPaper['practical'] : null;
                                } else {
                                    // Merged mode - get marks from config root
                                    $mcqMax = ($cfg['mcq'] ??  0) > 0 ? $cfg['mcq'] : null;
                                    $cqMax = ($cfg['cq'] ?? 0) > 0 ? $cfg['cq'] : null;
                                    $pracMax = ($cfg['practical'] ?? 0) > 0 ? $cfg['practical'] : null;
                                }
                            ?>
                            <thead class="bg-light sticky-top" style="z-index: 5;">
                                <tr>
                                    <th class="ps-3" style="width: 80px;">Roll</th>
                                    <th style="min-width: 150px;">Student Name</th>
                                    <?php if(($rule->paper_mode ?? 'merged') === 'separate'): ?>
                                        <?php if($fmcqMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">1st MCQ</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($fmcqMax); ?></div></th> <?php endif; ?>
                                        <?php if($fcqMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">1st CQ</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($fcqMax); ?></div></th> <?php endif; ?>
                                        <?php if($fpracMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">1st Prac</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($fpracMax); ?></div></th> <?php endif; ?>
                                        
                                        <?php if($subject->has_second_paper): ?>
                                            <?php if($smcqMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">2nd MCQ</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($smcqMax); ?></div></th> <?php endif; ?>
                                            <?php if($scqMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">2nd CQ</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($scqMax); ?></div></th> <?php endif; ?>
                                            <?php if($spracMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">2nd Prac</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($spracMax); ?></div></th> <?php endif; ?>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php if($mcqMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">MCQ</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($mcqMax); ?></div></th> <?php endif; ?>
                                        <?php if($cqMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">CQ</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($cqMax); ?></div></th> <?php endif; ?>
                                        <?php if($pracMax !== null): ?> <th class="text-center bg-white" style="width: 100px;"><div class="small fw-bold">Prac</div><div class="badge bg-light text-muted border text-dark fw-normal">Max: <?php echo e($pracMax); ?></div></th> <?php endif; ?>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $prev = $existing->get($st->id); ?>
                                    <tr>
                                        <td class="ps-3 fw-bold text-muted"><?php echo e($st->class_roll); ?></td>
                                        <td class="fw-bold text-dark"><?php echo e($st->name); ?>

                                            <input type="hidden" name="marks[<?php echo e($loop->index); ?>][student_id]" value="<?php echo e($st->id); ?>">
                                        </td>

                                        <?php if(($rule->paper_mode ?? 'merged') === 'separate'): ?>
                                            
                                            <?php if($fmcqMax !== null): ?>
                                                <td class="p-1"><input type="number" step="0.01" min="0" max="<?php echo e($fmcqMax); ?>" name="marks[<?php echo e($loop->index); ?>][first_paper_mcq]" value="<?php echo e($prev->first_paper_mcq ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                            <?php endif; ?>
                                            <?php if($fcqMax !== null): ?>
                                                 <td class="p-1"><input type="number" step="0.01" min="0" max="<?php echo e($fcqMax); ?>" name="marks[<?php echo e($loop->index); ?>][first_paper_cq]" value="<?php echo e($prev->first_paper_cq ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                            <?php endif; ?>
                                            <?php if($fpracMax !== null): ?>
                                                 <td class="p-1"><input type="number" step="0.01" min="0" max="<?php echo e($fpracMax); ?>" name="marks[<?php echo e($loop->index); ?>][first_paper_practical]" value="<?php echo e($prev->first_paper_practical ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                            <?php endif; ?>
                                            
                                            
                                            <?php if($subject->has_second_paper): ?>
                                                <?php if($smcqMax !== null): ?>
                                                    <td class="p-1 bg-light"><input type="number" step="0.01" min="0" max="<?php echo e($smcqMax); ?>" name="marks[<?php echo e($loop->index); ?>][second_paper_mcq]" value="<?php echo e($prev->second_paper_mcq ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                                <?php endif; ?>
                                                <?php if($scqMax !== null): ?>
                                                    <td class="p-1 bg-light"><input type="number" step="0.01" min="0" max="<?php echo e($scqMax); ?>" name="marks[<?php echo e($loop->index); ?>][second_paper_cq]" value="<?php echo e($prev->second_paper_cq ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                                <?php endif; ?>
                                                <?php if($spracMax !== null): ?>
                                                    <td class="p-1 bg-light"><input type="number" step="0.01" min="0" max="<?php echo e($spracMax); ?>" name="marks[<?php echo e($loop->index); ?>][second_paper_practical]" value="<?php echo e($prev->second_paper_practical ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            
                                            <?php if($mcqMax !== null): ?>
                                                <td class="p-1"><input type="number" step="0.01" min="0" max="<?php echo e($mcqMax); ?>" name="marks[<?php echo e($loop->index); ?>][first_paper_mcq]" value="<?php echo e($prev->first_paper_mcq ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                            <?php endif; ?>
                                            <?php if($cqMax !== null): ?>
                                                <td class="p-1"><input type="number" step="0.01" min="0" max="<?php echo e($cqMax); ?>" name="marks[<?php echo e($loop->index); ?>][first_paper_cq]" value="<?php echo e($prev->first_paper_cq ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                            <?php endif; ?>
                                            <?php if($pracMax !== null): ?>
                                                <td class="p-1"><input type="number" step="0.01" min="0" max="<?php echo e($pracMax); ?>" name="marks[<?php echo e($loop->index); ?>][first_paper_practical]" value="<?php echo e($prev->first_paper_practical ?? ''); ?>" class="form-control form-control-sm text-center fw-bold mark-input" placeholder="-"></td>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="card-footer bg-white py-3 sticky-bottom border-top shadow-sm" style="bottom: 0; z-index: 10;">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="<?php echo e(route('result-management.students', $exam)); ?>" class="btn btn-light border px-4">Cancel</a>
                            <button type="submit" class="btn btn-primary px-5 shadow-sm fw-bold"><i class="bi bi-save me-2"></i> Save All Marks</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    /* Focus effect specifically for mark inputs to highlight the active cell clearly */
    .mark-input:focus {
        background-color: #fff;
        border-color: #86b7fe;
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        z-index: 5;
        position: relative;
        transform: scale(1.05); /* Slight zoom on focus */
    }
    .sticky-bottom {
        position: sticky;
        bottom: 0;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Validation logic
        const inputs = document.querySelectorAll('.mark-input');
        
        inputs.forEach(input => {
            input.addEventListener('input', function() {
                const max = parseFloat(this.getAttribute('max'));
                const val = parseFloat(this.value);
                
                if (val > max) {
                    this.classList.add('is-invalid');
                    // Optional: Reset to max? or just warn. Let's strict warn.
                    this.value = max;
                    // Flash red
                    this.style.backgroundColor = '#ffe6e6';
                    setTimeout(() => {
                        this.style.backgroundColor = '';
                        this.classList.remove('is-invalid');
                    }, 500);
                } else if (val < 0) {
                     this.value = 0;
                }
            });

            // Arrow key navigation (Basic up/down)
            input.addEventListener('keydown', function(e) {
                if (e.key === 'ArrowDown' || e.key === 'ArrowUp' || e.key === 'Enter') {
                    // This is a bit complex due to grid but we can try basic next/prev in DOM order
                    // Real grid nav requires finding the index in the row and moving to next row same index
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/result-management/subject-entry.blade.php ENDPATH**/ ?>