

<?php $__env->startSection('title', 'Subject Details'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('subjects.index')); ?>">Subjects</a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e($subject->name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row justify-content-center">
    <div class="col-md-10">
        
        <!-- Identity Card -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold text-primary"><?php echo e($subject->name); ?></h5>
                <div>
                   <a href="<?php echo e(route('subjects.edit', $subject->id)); ?>" class="btn btn-warning btn-sm fw-bold"><i class="bi bi-pencil-square me-1"></i> Edit</a>
                   <a href="<?php echo e(route('subjects.index')); ?>" class="btn btn-light btn-sm border"><i class="bi bi-arrow-left me-1"></i> Back</a>
                </div>
            </div>
            <div class="card-body">
                <div class="row g-4">
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">Code</label>
                        <div class="fs-4 font-monospace fw-bold"><?php echo e($subject->code); ?></div>
                    </div>
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">Short Name</label>
                        <div class="fs-5"><?php echo e($subject->short_name ?? '-'); ?></div>
                    </div>
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">Configuration</label>
                        <div>
                            <?php if($subject->has_multiple_papers): ?>
                                <span class="badge bg-primary">Two Papers</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Single Paper</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="text-muted small text-uppercase fw-bold">4th Subject</label>
                        <div>
                            <?php if($subject->is_4th_subject_eligible): ?>
                                <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i> Eligible</span>
                            <?php else: ?>
                                <span class="badge bg-light text-muted border">Not Eligible</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Papers List -->
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light py-2">
                <h6 class="mb-0 fw-bold text-muted">Paper Configuration</h6>
            </div>
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="bg-white text-muted small text-uppercase">
                        <tr>
                            <th class="ps-4">Paper Type</th>
                            <th>Paper Code</th>
                            <th>Marks Distribution</th>
                            <th>Full Marks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $subject->papers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paper): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="ps-4 fw-bold text-primary">
                                <?php if($paper->paper_type === 'first'): ?> 1st Paper
                                <?php elseif($paper->paper_type === 'second'): ?> 2nd Paper
                                <?php else: ?> Single Paper
                                <?php endif; ?>
                            </td>
                            <td><span class="badge bg-white text-dark border font-monospace"><?php echo e($paper->paper_code); ?></span></td>
                            <td>
                                <div class="d-flex gap-2">
                                    <?php if($paper->has_cq): ?> <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25">CQ</span> <?php endif; ?>
                                    <?php if($paper->has_mcq): ?> <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25">MCQ</span> <?php endif; ?>
                                    <?php if($paper->has_practical): ?> <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">Practical</span> <?php endif; ?>
                                </div>
                            </td>
                            <td><?php echo e($paper->full_marks); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/subjects/show.blade.php ENDPATH**/ ?>