<header class="topbar">
    <button class="btn btn-icon btn-light d-lg-none" id="sidebarToggle">
        <i class="bi bi-list fs-4"></i>
    </button>
    
    <div class="d-none d-lg-block">
        <!-- Optional Global Search or Date -->
        <span class="text-muted small"><?php echo e(now()->format('l, d F Y')); ?></span>
    </div>

    <div class="d-flex align-items-center gap-3">
        <!-- Quick Actions (example) -->
        <div class="dropdown">
            <button class="btn btn-icon btn-light" data-bs-toggle="dropdown">
                <i class="bi bi-plus-lg"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end shadow border-0">
                <li><a class="dropdown-item" href="<?php echo e(route('students.create')); ?>"><i class="bi bi-person-plus me-2"></i> Add Student</a></li>
                <li><a class="dropdown-item" href="#"><i class="bi bi-file-earmark-plus me-2"></i> New Notice</a></li>
            </ul>
        </div>
        
        <!-- Notifications (example) -->
        <button class="btn btn-icon btn-light position-relative">
            <i class="bi bi-bell"></i>
            <span class="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
                <span class="visually-hidden">New alerts</span>
            </span>
        </button>

        <!-- User Profile -->
        <div class="dropdown">
            <button class="btn btn-light border-0 d-flex align-items-center gap-2 rounded-pill ps-2 pe-3 py-1 hover-bg-gray-100 transition" data-bs-toggle="dropdown" aria-expanded="false">
                <div class="avatar avatar-sm rounded-circle bg-primary text-white d-flex align-items-center justify-content-center fw-bold shadow-sm" style="width: 35px; height: 35px;">
                    <?php echo e(substr(Auth::user()->name ?? 'A', 0, 1)); ?>

                </div>
                <div class="d-none d-md-block text-start lh-1">
                    <div class="fw-bold text-dark small"><?php echo e(Auth::user()->name ?? 'Admin'); ?></div>
                    <div class="text-muted" style="font-size: 10px;"><?php echo e(Auth::user()->role ?? 'Administrator'); ?></div>
                </div>
                <i class="bi bi-chevron-down small text-muted ms-1"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end shadow-lg border-0 rounded-3 mt-2 py-2" style="min-width: 200px;">
                <li class="px-3 py-2 border-bottom mb-2">
                    <div class="d-flex align-items-center">
                        <div class="rounded-circle bg-primary bg-opacity-10 text-primary d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                             <i class="bi bi-person-fill"></i>
                        </div>
                        <div class="overflow-hidden">
                             <div class="fw-bold text-truncate small"><?php echo e(Auth::user()->name); ?></div>
                             <div class="text-muted text-truncate" style="font-size: 10px;"><?php echo e(Auth::user()->email); ?></div>
                        </div>
                    </div>
                </li>
                <li>
                    <a class="dropdown-item py-2 px-3 small" href="<?php echo e(route('profile.edit')); ?>">
                        <i class="bi bi-gear me-2 text-secondary"></i> Account Settings
                    </a>
                </li>
                <li><hr class="dropdown-divider my-1"></li>
                <li>
                     <form method="POST" action="<?php echo e(route('tyro-login.logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="dropdown-item py-2 px-3 small text-danger fw-bold">
                            <i class="bi bi-box-arrow-right me-2"></i> Logout
                        </button>
                    </form>
                </li>
            </ul>
        </div>
    </div>
</header>
<?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/admin/partials/topbar.blade.php ENDPATH**/ ?>