

<?php $__env->startSection('title', 'Select Batch'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('students.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i> Add New Student
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row g-4">
        <?php $__empty_1 = true; $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-6 col-lg-3">
                <a href="<?php echo e(route('students.index', ['batch_id' => $batch->id])); ?>" class="text-decoration-none">
                    <div class="card shadow-sm border-0 h-100 hover-shadow transition-all">
                        <div class="card-body text-center p-4">
                            <div class="mb-3 text-primary opacity-75">
                                <i class="bi bi-folder-fill display-1"></i>
                            </div>
                            <h5 class="fw-bold text-dark mb-1"><?php echo e($batch->name); ?></h5>
                            <p class="text-muted small mb-2"><?php echo e($batch->session); ?></p>

                            <span class="badge bg-primary-subtle text-primary rounded-pill px-3">
                                <?php echo e($batch->students_count); ?> Students
                            </span>
                        </div>
                    </div>
                </a>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12 text-center py-5">
                <div class="text-muted opacity-50 mb-3">
                    <i class="bi bi-folder-x display-1"></i>
                </div>
                <h4>No Batches Found</h4>
                <p class="text-muted">Create a batch first or add a student to auto-generate one.</p>
            </div>
        <?php endif; ?>

        <!-- All Students Option -->
        <div class="col-md-6 col-lg-3">
            <a href="<?php echo e(route('students.index', ['search' => ' '])); ?>" class="text-decoration-none">
                <div class="card shadow-sm border-0 h-100 hover-shadow transition-all bg-light">
                    <div class="card-body text-center p-4">
                        <div class="mb-3 text-secondary opacity-50">
                            <i class="bi bi-people-fill display-1"></i>
                        </div>
                        <h5 class="fw-bold text-dark mb-1">All Students</h5>
                        <p class="text-muted small mb-2">View Global List</p>

                        <span class="badge bg-secondary rounded-pill px-3">
                            Global Search
                        </span>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <style>
        .hover-shadow:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1) !important;
        }

        .transition-all {
            transition: all 0.3s ease;
        }
    </style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/students/batches.blade.php ENDPATH**/ ?>