<?php $__env->startSection('title', 'System Settings'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Settings</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid p-0">
    <div class="row">
        <!-- Settings Navigation (Sidebar/Tabs) -->
        <div class="col-12 col-lg-3 mb-4">
            <div class="card shadow-sm border-0 rounded-lg">
                <div class="list-group list-group-flush" id="settings-tab" role="tablist">
                    <a class="list-group-item list-group-item-action active fw-bold py-3" id="list-general-list" data-bs-toggle="list" href="#list-general" role="tab">
                        <i class="bi bi-gear me-2 text-primary"></i> General Settings
                    </a>
                    <a class="list-group-item list-group-item-action fw-bold py-3" id="list-social-list" data-bs-toggle="list" href="#list-social" role="tab">
                        <i class="bi bi-share me-2 text-info"></i> Social & Footer
                    </a>
                    <a class="list-group-item list-group-item-action fw-bold py-3" id="list-contact-list" data-bs-toggle="list" href="#list-contact" role="tab">
                        <i class="bi bi-telephone me-2 text-success"></i> Contact Info
                    </a>
                    <a class="list-group-item list-group-item-action fw-bold py-3" id="list-principal-list" data-bs-toggle="list" href="#list-principal" role="tab">
                        <i class="bi bi-person-workspace me-2 text-warning"></i> Principal Msg
                    </a>
                    <a class="list-group-item list-group-item-action fw-bold py-3" id="list-grading-list" data-bs-toggle="list" href="#list-grading" role="tab">
                        <i class="bi bi-award me-2 text-danger"></i> Grading System
                    </a>
                </div>
            </div>
            
            <div class="card shadow-sm border-0 rounded-lg mt-3 bg-primary text-white">
                <div class="card-body text-center p-4">
                    <h5 class="mb-3"><i class="bi bi-save2 fa-2x"></i></h5>
                    <p class="small text-white-50 mb-3">Don't forget to save your changes!</p>
                    <button type="submit" form="settingsForm" class="btn btn-light w-100 fw-bold text-primary shadow-sm">
                        Save All Changes
                    </button>
                    <p class="small text-white-50 mt-2 mb-0">Last updated: <?php echo e(now()->format('d M, h:i A')); ?></p>
                </div>
            </div>
        </div>

        <!-- Settings Content -->
        <div class="col-12 col-lg-9">
            <form action="<?php echo e(route('settings.update')); ?>" method="POST" enctype="multipart/form-data" id="settingsForm">
                <?php echo csrf_field(); ?>
                <div class="tab-content" id="nav-tabContent">
                    
                    <!-- General Settings -->
                    <div class="tab-pane fade show active" id="list-general" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-primary">Website Identity</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">College Name</label>
                                        <input type="text" name="college_name" value="<?php echo e(old('college_name', $values['college_name'] ?? '')); ?>" class="form-control form-control-lg" placeholder="e.g. Dhaka College">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Tagline / Slogan</label>
                                        <input type="text" name="tagline" value="<?php echo e(old('tagline', $values['tagline'] ?? '')); ?>" class="form-control form-control-lg" placeholder="e.g. Excellence in Education">
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Site Logo</label>
                                        <div class="input-group">
                                            <input type="file" name="site_logo" class="form-control" accept="image/*">
                                        </div>
                                        <?php if(!empty($values['site_logo'])): ?>
                                            <div class="mt-2 p-2 border rounded bg-light d-inline-block">
                                                <img src="<?php echo e(asset('storage/uploads/settings/' . basename($values['site_logo']))); ?>" alt="Logo" height="40">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Favicon</label>
                                        <div class="input-group">
                                            <input type="file" name="site_favicon" class="form-control" accept="image/*">
                                        </div>
                                         <?php if(!empty($values['site_favicon'])): ?>
                                            <div class="mt-2 p-2 border rounded bg-light d-inline-block">
                                                <img src="<?php echo e(asset('storage/uploads/settings/' . basename($values['site_favicon']))); ?>" alt="Favicon" height="32">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                     <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Controller Signature (Result Sheet)</label>
                                        <div class="input-group">
                                            <input type="file" name="controller_examination_signature" class="form-control" accept="image/*">
                                        </div>
                                         <?php if(!empty($values['controller_examination_signature'])): ?>
                                            <div class="mt-2 p-2 border rounded bg-light d-inline-block">
                                                <img src="<?php echo e(asset('storage/uploads/settings/' . basename($values['controller_examination_signature']))); ?>" alt="Signature" height="40">
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Meta Description (SEO)</label>
                                        <textarea name="description" rows="3" class="form-control" placeholder="Brief description for search engines..."><?php echo e(old('description', $values['description'] ?? '')); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Social & Footer -->
                    <div class="tab-pane fade" id="list-social" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-info">Social Media & Footer</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Footer About Text</label>
                                        <textarea name="footer_about" rows="3" class="form-control" placeholder="Short text about the college for the footer..."><?php echo e(old('footer_about', $values['footer_about'] ?? '')); ?></textarea>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-facebook me-1"></i> Facebook URL</label>
                                        <input type="url" name="social_facebook" value="<?php echo e(old('social_facebook', $values['social_facebook'] ?? '')); ?>" class="form-control" placeholder="https://facebook.com/...">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-youtube me-1"></i> YouTube URL</label>
                                        <input type="url" name="social_youtube" value="<?php echo e(old('social_youtube', $values['social_youtube'] ?? '')); ?>" class="form-control" placeholder="https://youtube.com/...">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-twitter me-1"></i> Twitter / X URL</label>
                                        <input type="url" name="social_twitter" value="<?php echo e(old('social_twitter', $values['social_twitter'] ?? '')); ?>" class="form-control" placeholder="https://twitter.com/...">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted"><i class="bi bi-instagram me-1"></i> Instagram URL</label>
                                        <input type="url" name="social_instagram" value="<?php echo e(old('social_instagram', $values['social_instagram'] ?? '')); ?>" class="form-control" placeholder="https://instagram.com/...">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Info -->
                    <div class="tab-pane fade" id="list-contact" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-success">Contact Information</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Full Address</label>
                                        <textarea name="contact_full_address" rows="3" class="form-control" placeholder="Street Address, City, Postal Code"><?php echo e(old('contact_full_address', $values['contact_full_address'] ?? '')); ?></textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Office Phone</label>
                                        <input type="text" name="contact_office_phone" value="<?php echo e(old('contact_office_phone', $values['contact_office_phone'] ?? '')); ?>" class="form-control">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Mobile / Hotline</label>
                                        <input type="text" name="contact_mobile_phone" value="<?php echo e(old('contact_mobile_phone', $values['contact_mobile_phone'] ?? '')); ?>" class="form-control">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">Principal Email</label>
                                        <input type="email" name="contact_principal_email" value="<?php echo e(old('contact_principal_email', $values['contact_principal_email'] ?? '')); ?>" class="form-control">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-muted">General / Info Email</label>
                                        <input type="email" name="contact_general_email" value="<?php echo e(old('contact_general_email', $values['contact_general_email'] ?? '')); ?>" class="form-control">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Google Maps Iframe URL</label>
                                        <textarea name="contact_map_url" rows="2" class="form-control" placeholder="https://www.google.com/maps/embed?..."><?php echo e(old('contact_map_url', $values['contact_map_url'] ?? '')); ?></textarea>
                                        <div class="form-text">Paste the 'src' attribute from the Google Maps Embed code.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Principal Message Settings -->
                    <div class="tab-pane fade" id="list-principal" role="tabpanel">
                        <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom">
                                <h5 class="m-0 fw-bold text-warning">Principal's Message Configuration</h5>
                            </div>
                            <div class="card-body p-4">
                                <div class="row g-4">
                                    <div class="col-md-8">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold small text-muted">Principal Name</label>
                                            <input type="text" name="principal_name" value="<?php echo e(old('principal_name', $values['principal_name'] ?? '')); ?>" class="form-control form-control-lg" placeholder="Mr. Name">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label fw-bold small text-muted">Short Message (Home Page)</label>
                                            <textarea name="principal_message_short" rows="5" class="form-control" placeholder="Welcome message..."><?php echo e(old('principal_message_short', $values['principal_message_short'] ?? '')); ?></textarea>
                                            <div class="form-text">This message will appear on the dashboard/home page.</div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold small text-muted">Principal Image</label>
                                        <div class="card bg-light border-0 text-center p-3 mb-2">
                                            <?php
                                                $p_img = isset($values['principal_image']) ? asset('storage/'.$values['principal_image']) : 'https://via.placeholder.com/150';
                                            ?>
                                            <img id="principal_preview" src="<?php echo e($p_img); ?>" class="img-fluid rounded-circle shadow-sm mb-2" style="width: 150px; height: 150px; object-fit: cover;">
                                            <div class="small text-muted">Preview</div>
                                        </div>
                                        <input type="file" name="principal_image" class="form-control" accept="image/*" onchange="document.getElementById('principal_preview').src = window.URL.createObjectURL(this.files[0])">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-bold small text-muted">Full Message</label>
                                        <textarea name="principal_message" rows="8" class="form-control"><?php echo e(old('principal_message', $values['principal_message'] ?? '')); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Grading System -->
                    <div class="tab-pane fade" id="list-grading" role="tabpanel">
                         <div class="card shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-white py-3 border-bottom d-flex justify-content-between align-items-center">
                                <h5 class="m-0 fw-bold text-danger">Exam Grading System</h5>
                                <span class="badge bg-warning text-dark">Impacts all calculations</span>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover mb-0 text-center align-middle">
                                        <thead class="bg-light">
                                            <tr>
                                                <th class="py-3">Grade</th>
                                                <th class="py-3">Min %</th>
                                                <th class="py-3">Max %</th>
                                                <th class="py-3">GPA</th>
                                                <th class="py-3">Display Color</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $gradeRules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="text" name="grade_rules[<?php echo e($index); ?>][grade]" value="<?php echo e($rule['grade']); ?>" class="form-control text-center fw-bold border-0 bg-transparent" readonly tabindex="-1">
                                                    </td>
                                                    <td class="px-4">
                                                        <input type="number" step="0.01" name="grade_rules[<?php echo e($index); ?>][min_percentage]" value="<?php echo e($rule['min_percentage']); ?>" class="form-control text-center" required>
                                                    </td>
                                                    <td class="px-4">
                                                        <input type="number" step="0.01" name="grade_rules[<?php echo e($index); ?>][max_percentage]" value="<?php echo e($rule['max_percentage']); ?>" class="form-control text-center" required>
                                                    </td>
                                                    <td class="px-4">
                                                        <input type="number" step="0.1" name="grade_rules[<?php echo e($index); ?>][gpa]" value="<?php echo e($rule['gpa']); ?>" class="form-control text-center bg-light" required>
                                                    </td>
                                                    <td>
                                                        <input type="color" name="grade_rules[<?php echo e($index); ?>][color]" value="<?php echo e($rule['color']); ?>" class="form-control form-control-color w-100" style="cursor: pointer;">
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                         </div>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Ensure last active tab is remembered if needed, or simple redirect back to index
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH T:\Motiur\college\admin\resources\views/settings/index.blade.php ENDPATH**/ ?>