

<?php $__env->startSection('title', 'Select Batch for Results'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('exams.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i> Create Exam
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row g-4">
        <?php $__empty_1 = true; $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-6 col-lg-3">
                <a href="<?php echo e(route('result-management.index', ['batch_id' => $batch->id])); ?>" class="text-decoration-none">
                    <div class="card shadow-sm border-0 h-100 hover-shadow transition-all">
                        <div class="card-body text-center p-4">
                            <div class="mb-3 text-success opacity-75">
                                <i class="bi bi-mortarboard-fill display-1"></i>
                            </div>
                            <h5 class="fw-bold text-dark mb-1"><?php echo e($batch->name); ?></h5>
                            <p class="text-muted small mb-2"><?php echo e($batch->session); ?></p>

                            <span class="badge bg-success-subtle text-success rounded-pill px-3">
                                <?php echo e($batch->exams_count); ?> Exams to Grade
                            </span>
                        </div>
                    </div>
                </a>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12 text-center py-5">
                <div class="text-muted opacity-50 mb-3">
                    <i class="bi bi-journal-x display-1"></i>
                </div>
                <h4>No Exams Found</h4>
                <p class="text-muted">Create an exam first to see it here.</p>
            </div>
        <?php endif; ?>

        <!-- All Exams Option -->
        <div class="col-md-6 col-lg-3">
            <a href="<?php echo e(route('exams.create')); ?>" class="text-decoration-none">
                <div class="card shadow-sm border-0 h-100 hover-shadow transition-all bg-light">
                    <div class="card-body text-center p-4">
                        <div class="mb-3 text-secondary opacity-50">
                            <i class="bi bi-plus-circle display-1"></i>
                        </div>
                        <h5 class="fw-bold text-dark mb-1">New Exam</h5>
                        <p class="text-muted small mb-2">Schedule a new exam</p>

                        <span class="badge bg-secondary rounded-pill px-3">
                            Create
                        </span>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <style>
        .hover-shadow:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1) !important;
        }

        .transition-all {
            transition: all 0.3s ease;
        }
    </style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADMIN\Desktop\admin\resources\views/result-management/batches.blade.php ENDPATH**/ ?>