<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title><?php echo e($exam->name); ?> - Result Sheet</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 14px;
            color: #000;
        }

        .container {
            width: 100%;
            margin: 0 auto;
            padding: 10px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
            text-transform: uppercase;
        }

        .header h3 {
            margin: 5px 0 0;
            font-size: 18px;
            font-weight: normal;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: center;
        }

        th {
            background-color: #f0f0f0;
            font-weight: bold;
        }

        .text-left {
            text-align: left !important;
        }

        .footer-section {
            margin-top: 40px;
            display: flex;
            justify-content: flex-end;
        }

        .signature-box {
            text-align: center;
            width: 250px;
        }

        .signature-line {
            border-top: 1px solid #000;
            margin: 5px 0;
        }

        @media print {
            body {
                -webkit-print-color-adjust: exact;
                margin: 0;
            }

            .no-print {
                display: none;
            }

            table {
                font-size: 12px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h2>Sheikh Abdul Wohab Model College</h2>
            <h3><?php echo e($exam->name); ?> - Result Sheet</h3>
            <p style="margin: 5px 0;">Year: <?php echo e(date('Y', strtotime($exam->start_date))); ?> | Batch:
                <?php echo e($exam->batch->name); ?></p>
        </div>

        <table>
            <thead>
                <tr>
                    <th style="width: 5%">Rank</th>
                    <th style="width: 10%">Roll No</th>
                    <th style="width: 35%">Student Name</th>
                    <th style="width: 15%">Total Marks</th>
                    <th style="width: 10%">GPA</th>
                    <th style="width: 10%">Grade</th>
                    <th style="width: 15%">Result</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($result->position); ?></td>
                        <td><?php echo e($result->student->class_roll); ?></td>
                        <td class="text-left"><?php echo e($result->student->name); ?></td>
                        <td><?php echo e(number_format($result->total_marks, 0)); ?></td>
                        <td><?php echo e(number_format($result->gpa, 2)); ?></td>
                        <td><?php echo e($result->grade); ?></td>
                        <td><?php echo e($result->result_status == 'passed' ? 'PASSED' : 'FAILED'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="footer-section">
            <div class="signature-box">
                <?php if($signature): ?>
                    <img src="<?php echo e(asset('storage/' . $signature)); ?>" height="50" alt="Signature">
                <?php else: ?>
                    <div style="height: 50px;"></div>
                <?php endif; ?>
                <div class="signature-line"></div>
                <strong>Controller of Examinations</strong>
            </div>
        </div>
    </div>
    <script>
        window.onload = function () {
            setTimeout(function () {
                window.print();
            }, 500);
        }
    </script>
</body>

</html><?php /**PATH C:\Users\Administrator\Downloads\admin\admin\resources\views/exports/result-sheet.blade.php ENDPATH**/ ?>