<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User; // Assuming admin/user auth
use App\Models\Exam;
use App\Models\Student;
use App\Models\Subject;
use App\Models\ExamSubjectRule;
use App\Models\ResultMark;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ExamResultTest extends TestCase
{
    use RefreshDatabase;

    public function test_gpa_calculation_logic()
    {
        // 1. Setup Student and Exam
        $student = Student::create([
            'name' => 'Test Student',
            'class_roll' => '101',
            'ssc_reg_no' => '123456',
            'status' => 'active',
            'hsc_batch' => '2025',
            'batch_id' => 1, // assumes batch 1 exists or is nullable, usually batch_id is required.
            // Add other required fields if any (check migration/model fillables)
        ]);

        $exam = Exam::create([
            'name' => 'Test Exam',
            'start_date' => now(),
            'batch_id' => $student->batch_id,
            'status' => 'draft',
            // Add other required fields
        ]);

        $subject = Subject::create([
            'name' => 'Test Subject',
            'code' => '101',
            'type' => 'theory',
            'mark_system' => 'creative',
            // Add other required fields
        ]);

        // 2. Setup Rule (Total 100, Pass 33)
        $rule = ExamSubjectRule::create([
            'exam_id' => $exam->id,
            'subject_id' => $subject->id,
            'total_marks' => 100,
            'pass_marks' => 33,
            'paper_mode' => 'active', // or whatever the enum is
        ]);

        // 3. Calculate 80% (GPA 5.0)
        $obtained = 80;
        $percentage = ($obtained / 100) * 100;
        $gpa = ResultMark::calculateGPAFromPercentage($percentage);
        $grade = ResultMark::getGradeFromPercentage($percentage);

        $this->assertEquals(5.00, $gpa);
        $this->assertEquals('A+', $grade);

        // 4. Calculate 32% (Fail)
        $obtainedFail = 32;
        $percentageFail = ($obtainedFail / 100) * 100;
        $isFailed = $obtainedFail < $rule->pass_marks;

        $this->assertTrue($isFailed);
    }
}
