@extends('tyro-login::layouts.auth')

@section('content')
<div class="auth-container {{ $layout }}" @if($layout==='fullscreen' ) style="background-image: url('{{ $backgroundImage }}');" @endif>
    @if(in_array($layout, ['split-left', 'split-right']))
    <div class="background-panel" style="background-image: url('{{ $backgroundImage }}');">
        <div class="background-panel-content">
            <h1>{{ $pageContent['background_title'] ?? 'Email Verification Required' }}</h1>
            <p>{{ $pageContent['background_description'] ?? 'Your email address needs to be verified before you can access your account.' }}</p>
        </div>
    </div>
    @endif

    <div class="form-panel">
        <div class="form-card">
            <!-- Logo -->
            <div class="logo-container">
                @if($branding['logo'] ?? false)
                <img src="{{ $branding['logo'] }}" alt="{{ $branding['app_name'] ?? config('app.name') }}">
                @else
                <div class="app-logo">
                    <svg viewBox="0 0 50 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M49.626 11.564a.809.809 0 0 1 .028.209v10.972a.8.8 0 0 1-.402.694l-9.209 5.302V39.25c0 .286-.152.55-.4.694L20.42 51.01c-.044.025-.092.041-.14.058-.018.006-.035.017-.054.022a.805.805 0 0 1-.41 0c-.022-.006-.042-.018-.063-.026-.044-.016-.09-.03-.132-.054L.402 39.944A.801.801 0 0 1 0 39.25V6.334c0-.072.01-.142.028-.21.006-.023.02-.044.028-.067.015-.042.029-.085.051-.124.015-.026.037-.047.055-.071.023-.032.044-.065.071-.093.023-.023.053-.04.079-.06.029-.024.055-.05.088-.069h.001l9.61-5.533a.802.802 0 0 1 .8 0l9.61 5.533h.002c.032.02.059.045.088.068.026.02.055.038.078.06.028.029.048.062.072.094.017.024.04.045.054.071.023.04.036.082.052.124.008.023.022.044.028.068a.809.809 0 0 1 .028.209v20.559l8.008-4.611v-10.51c0-.07.01-.141.028-.208.007-.024.02-.045.028-.068.016-.042.03-.085.052-.124.015-.026.037-.047.054-.071.024-.032.044-.065.072-.093.023-.023.052-.04.078-.06.03-.024.056-.05.088-.069h.001l9.611-5.533a.801.801 0 0 1 .8 0l9.61 5.533c.034.02.06.045.09.068.025.02.054.038.077.06.028.029.048.062.072.094.018.024.04.045.054.071.023.039.036.082.052.124.009.023.022.044.028.068zm-1.574 10.718v-9.124l-3.363 1.936-4.646 2.675v9.124l8.01-4.611zm-9.61 16.505v-9.13l-4.57 2.61-13.05 7.448v9.216l17.62-10.144zM1.602 7.719v31.068L19.22 48.93v-9.214l-9.204-5.209-.003-.002-.004-.002c-.031-.018-.057-.044-.086-.066-.025-.02-.054-.036-.076-.058l-.002-.003c-.026-.025-.044-.056-.066-.084-.02-.027-.044-.05-.06-.078l-.001-.003c-.018-.03-.029-.066-.042-.1-.013-.03-.03-.058-.038-.09v-.001c-.01-.038-.012-.078-.016-.117-.004-.03-.012-.06-.012-.09v-.002-21.481L4.965 9.654 1.602 7.72zm8.81-5.994L2.405 6.334l8.005 4.609 8.006-4.61-8.006-4.608zm4.164 28.764l4.645-2.674V7.719l-3.363 1.936-4.646 2.675v20.096l3.364-1.937zM39.243 7.164l-8.006 4.609 8.006 4.609 8.005-4.61-8.005-4.608zm-.801 10.605l-4.646-2.675-3.363-1.936v9.124l4.645 2.674 3.364 1.937v-9.124zM20.02 38.33l11.743-6.704 5.87-3.35-8-4.606-9.211 5.303-8.395 4.833 7.993 4.524z" fill="currentColor" />
                    </svg>
                </div>
                @endif
            </div>

            <!-- Warning Icon -->
            <!-- <div class="warning-icon-container">
                <svg class="warning-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m9-.75a9 9 0 11-18 0 9 9 0 0118 0zm-9 3.75h.008v.008H12v-.008z" />
                </svg>
            </div> -->

            <!-- Header -->
            <div class="form-header">
                <h2>{{ $pageContent['title'] ?? 'Email Not Verified' }}</h2>
                <p>{{ $pageContent['subtitle'] ?? 'Please verify your email address to continue.' }}</p>
            </div>

            <!-- Email Address -->
            <div class="email-notice">
                <p>A verification link was sent to:</p>
                <p class="email-address">{{ $email }}</p>
            </div>

            <!-- Success Message -->
            @if(session('success'))
            <div class="success-message">
                <p>{{ session('success') }}</p>
            </div>
            @endif

            <!-- Instructions -->
            <div class="verify-instructions">
                <p>Please check your inbox and click the verification link to activate your account. If you don't see the email, check your spam folder.</p>
            </div>

            <!-- Resend Link -->
            <form method="POST" action="{{ route('tyro-login.verification.resend') }}">
                @csrf
                <button type="submit" class="btn btn-primary">
                    Resend Verification Email
                </button>
            </form>

            <!-- Back to Login -->
            <div class="form-footer">
                <p>
                    <a href="{{ route('tyro-login.login') }}" class="form-link">Back to Login</a>
                </p>
            </div>
        </div>
    </div>
</div>

<style>
    .warning-icon-container {
        text-align: center;
        margin-bottom: 1rem;
    }

    .warning-icon {
        width: 3.5rem;
        height: 3.5rem;
        color: #f59e0b;
    }

    html.dark .warning-icon {
        color: #fbbf24;
    }

    .email-notice {
        text-align: center;
        margin-bottom: 1.5rem;
        padding: 1rem;
        background-color: var(--muted);
        border-radius: 0.5rem;
        border: 1px solid var(--border);
    }

    .email-notice p {
        color: var(--muted-foreground);
        font-size: 0.875rem;
        margin: 0;
    }

    .email-notice .email-address {
        color: var(--foreground);
        font-weight: 600;
        font-size: 1rem;
        margin-top: 0.25rem;
    }

    .success-message {
        background-color: #ecfdf5;
        border: 1px solid #a7f3d0;
        border-radius: 0.5rem;
        padding: 1rem;
        margin-bottom: 1.5rem;
        text-align: center;
    }

    html.dark .success-message {
        background-color: #052e16;
        border-color: #166534;
    }

    .success-message p {
        color: #059669;
        font-size: 0.875rem;
        margin: 0;
    }

    html.dark .success-message p {
        color: #34d399;
    }

    .verify-instructions {
        text-align: center;
        margin-bottom: 1.5rem;
    }

    .verify-instructions p {
        color: var(--muted-foreground);
        font-size: 0.875rem;
        line-height: 1.6;
    }
</style>
@endsection